/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.frontend.icons;

import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;

public class FrontendIconsUtil {
    private static final String _ICONS_BASE_PATH = "/o/icons";
    private static final String _SYSTEM_ICON_PACK_NAME = "clay";

    public static String getBasePath() {
        return PortalUtil.getPathContext() + _ICONS_BASE_PATH;
    }

    public static String getSpritemap(ThemeDisplay themeDisplay) {
        if (!GetterUtil.getBoolean(PropsUtil.get("feature.flag.LPS-145112"))) {
            return themeDisplay.getPathThemeImages() + "/clay/icons.svg";
        }
        Theme theme = themeDisplay.getTheme();
        if (theme.isControlPanelTheme()) {
            return FrontendIconsUtil.getSystemSpritemap();
        }
        return FrontendIconsUtil._getSpritemap(themeDisplay.getSiteGroupId());
    }

    public static String getSystemIconPackName() {
        return _SYSTEM_ICON_PACK_NAME;
    }

    public static String getSystemSpritemap() {
        return FrontendIconsUtil._getSpritemap(_SYSTEM_ICON_PACK_NAME);
    }

    private static String _getSpritemap(long siteId) {
        return StringBundler.concat(FrontendIconsUtil.getBasePath(), "/site/", String.valueOf(siteId), ".svg");
    }

    private static String _getSpritemap(String name) {
        return StringBundler.concat(FrontendIconsUtil.getBasePath(), "/pack/", name, ".svg");
    }
}

