/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.internal.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.lang.reflect.Method;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class SystemCheckerUtil {
    public static void runSystemCheckers(Log log) {
        BundleContext bundleContext = SystemBundleUtil.getBundleContext();
        try {
            ServiceReference[] serviceReferences = bundleContext.getAllServiceReferences("com.liferay.portal.osgi.debug.SystemChecker", null);
            if (serviceReferences == null) {
                if (log.isWarnEnabled()) {
                    log.warn("No system checkers available");
                }
                return;
            }
            for (ServiceReference serviceReference : serviceReferences) {
                Object systemChecker = bundleContext.getService(serviceReference);
                StringBundler sb = new StringBundler(4);
                sb.append("Running \"");
                sb.append(systemChecker);
                sb.append("\" check result: ");
                Class<?> clazz = systemChecker.getClass();
                Method method = clazz.getMethod("check", new Class[0]);
                Object result = method.invoke(systemChecker, new Object[0]);
                if (Validator.isNull(result)) {
                    sb.append("No issues were found.");
                    if (log.isInfoEnabled()) {
                        log.info(sb.toString());
                    }
                } else if (log.isWarnEnabled()) {
                    sb.append(result);
                    log.warn(sb.toString());
                }
                bundleContext.ungetService(serviceReference);
            }
        }
        catch (Exception exception) {
            log.error(exception, exception);
        }
    }

    private SystemCheckerUtil() {
    }
}

