/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging;

import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageBusException;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.sender.SynchronousMessageSender;
import com.liferay.portal.kernel.util.ServiceProxyFactory;

public class MessageBusUtil {
    private static volatile SynchronousMessageSender _defaultSynchronousMessageSender = ServiceProxyFactory.newServiceTrackedInstance(SynchronousMessageSender.class, MessageBusUtil.class, "_defaultSynchronousMessageSender", "(mode=DEFAULT)", true);
    private static volatile SynchronousMessageSender _directSynchronousMessageSender = ServiceProxyFactory.newServiceTrackedInstance(SynchronousMessageSender.class, MessageBusUtil.class, "_directSynchronousMessageSender", "(mode=DIRECT)", true);
    private static volatile MessageBus _messageBus = ServiceProxyFactory.newServiceTrackedInstance(MessageBus.class, MessageBusUtil.class, "_messageBus", true);
    private static SynchronousMessageSender.Mode _synchronousMessageSenderMode;

    public static Message createResponseMessage(Message requestMessage) {
        Message responseMessage = new Message();
        responseMessage.setDestinationName(requestMessage.getResponseDestinationName());
        responseMessage.setResponseId(requestMessage.getResponseId());
        return responseMessage;
    }

    public static Message createResponseMessage(Message requestMessage, Object payload) {
        Message responseMessage = MessageBusUtil.createResponseMessage(requestMessage);
        responseMessage.setPayload(payload);
        return responseMessage;
    }

    public static Destination getDestination(String destinationName) {
        return _messageBus.getDestination(destinationName);
    }

    public static MessageBus getMessageBus() {
        return _messageBus;
    }

    public static boolean hasMessageListener(String destination) {
        return _messageBus.hasMessageListener(destination);
    }

    public static void registerMessageListener(String destinationName, MessageListener messageListener) {
        _messageBus.registerMessageListener(destinationName, messageListener);
    }

    public static void sendMessage(String destinationName, Message message) {
        _messageBus.sendMessage(destinationName, message);
    }

    public static void sendMessage(String destinationName, Object payload) {
        Message message = new Message();
        message.setPayload(payload);
        _messageBus.sendMessage(destinationName, message);
    }

    public static Object sendSynchronousMessage(String destinationName, Message message) throws MessageBusException {
        SynchronousMessageSender synchronousMessageSender = MessageBusUtil._getSynchronousMessageSender();
        return synchronousMessageSender.send(destinationName, message);
    }

    public static Object sendSynchronousMessage(String destinationName, Message message, long timeout) throws MessageBusException {
        SynchronousMessageSender synchronousMessageSender = MessageBusUtil._getSynchronousMessageSender();
        return synchronousMessageSender.send(destinationName, message, timeout);
    }

    public static Object sendSynchronousMessage(String destinationName, Object payload) throws MessageBusException {
        return MessageBusUtil.sendSynchronousMessage(destinationName, payload, null);
    }

    public static Object sendSynchronousMessage(String destinationName, Object payload, long timeout) throws MessageBusException {
        return MessageBusUtil.sendSynchronousMessage(destinationName, payload, null, timeout);
    }

    public static Object sendSynchronousMessage(String destinationName, Object payload, String responseDestinationName) throws MessageBusException {
        Message message = new Message();
        message.setResponseDestinationName(responseDestinationName);
        message.setPayload(payload);
        return MessageBusUtil.sendSynchronousMessage(destinationName, message);
    }

    public static Object sendSynchronousMessage(String destinationName, Object payload, String responseDestinationName, long timeout) throws MessageBusException {
        Message message = new Message();
        message.setResponseDestinationName(responseDestinationName);
        message.setPayload(payload);
        return MessageBusUtil.sendSynchronousMessage(destinationName, message, timeout);
    }

    public static void shutdown() {
        _messageBus.shutdown();
    }

    public static void shutdown(boolean force) {
        _messageBus.shutdown(force);
    }

    public static boolean unregisterMessageListener(String destinationName, MessageListener messageListener) {
        return _messageBus.unregisterMessageListener(destinationName, messageListener);
    }

    public void setSynchronousMessageSenderMode(SynchronousMessageSender.Mode synchronousMessageSenderMode) {
        _synchronousMessageSenderMode = synchronousMessageSenderMode;
    }

    private static SynchronousMessageSender _getSynchronousMessageSender() {
        if (_synchronousMessageSenderMode == SynchronousMessageSender.Mode.DEFAULT) {
            return _defaultSynchronousMessageSender;
        }
        return _directSynchronousMessageSender;
    }
}

