/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging.config;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.DestinationEventListener;
import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.messaging.DestinationFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageBusEventListener;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.config.MessagingConfigurator;
import com.liferay.portal.kernel.messaging.config.MessagingConfiguratorRegistry;
import com.liferay.portal.kernel.module.util.ServiceLatch;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.servlet.ServletContextClassLoaderPool;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class DefaultMessagingConfigurator
implements MessagingConfigurator {
    private final Set<DestinationConfiguration> _destinationConfigurations = new HashSet<DestinationConfiguration>();
    private final Map<String, List<DestinationEventListener>> _destinationEventListeners = new HashMap<String, List<DestinationEventListener>>();
    private final List<Destination> _destinations = new ArrayList<Destination>();
    private volatile MessageBus _messageBus;
    private final List<MessageBusEventListener> _messageBusEventListeners = new ArrayList<MessageBusEventListener>();
    private final Map<String, List<MessageListener>> _messageListeners = new HashMap<String, List<MessageListener>>();
    private final List<ServiceRegistration<?>> _serviceRegistrations = new ArrayList();

    public void afterPropertiesSet() {
        ServiceLatch serviceLatch = SystemBundleUtil.newServiceLatch();
        serviceLatch.waitFor(DestinationFactory.class);
        serviceLatch.waitFor(MessageBus.class, messageBus -> {
            this._messageBus = messageBus;
        });
        serviceLatch.openOn(this::initialize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(this.getOperatingClassLoader());
            for (Map.Entry<String, List<MessageListener>> messageListeners : this._messageListeners.entrySet()) {
                String destinationName = messageListeners.getKey();
                ServiceLatch serviceLatch = SystemBundleUtil.newServiceLatch();
                serviceLatch.waitFor(StringBundler.concat((String[])new String[]{"(&(destination.name=", destinationName, ")(objectClass=", Destination.class.getName(), "))"}));
                serviceLatch.openOn(bundleContext -> {
                    HashMapDictionary<String, String> properties = HashMapDictionaryBuilder.put("destination.name", destinationName).put("message.listener.operating.class.loader", (String)((Object)this.getOperatingClassLoader())).build();
                    for (MessageListener messageListener : (List)messageListeners.getValue()) {
                        this._serviceRegistrations.add(bundleContext.registerService(MessageListener.class, (Object)messageListener, properties));
                    }
                });
            }
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    @Override
    public void destroy() {
        for (ServiceRegistration<?> serviceRegistration : this._serviceRegistrations) {
            serviceRegistration.unregister();
        }
        this._serviceRegistrations.clear();
        this._destinationConfigurations.clear();
        this._destinationEventListeners.clear();
        this._messageListeners.clear();
        for (Destination destination : this._destinations) {
            destination.destroy();
        }
        this._destinations.clear();
        this._messageBusEventListeners.clear();
        String servletContextName = ServletContextClassLoaderPool.getServletContextName(this.getOperatingClassLoader());
        if (servletContextName != null) {
            MessagingConfiguratorRegistry.unregisterMessagingConfigurator(servletContextName, this);
        }
    }

    @Override
    public void disconnect() {
        for (Map.Entry<String, List<MessageListener>> messageListeners : this._messageListeners.entrySet()) {
            String destinationName = messageListeners.getKey();
            for (MessageListener messageListener : messageListeners.getValue()) {
                this._messageBus.unregisterMessageListener(destinationName, messageListener);
            }
        }
    }

    @Override
    public void setDestinationConfigurations(Set<DestinationConfiguration> destinationConfigurations) {
        this._destinationConfigurations.addAll(destinationConfigurations);
    }

    @Override
    public void setDestinationEventListeners(Map<String, List<DestinationEventListener>> destinationEventListeners) {
        this._destinationEventListeners.putAll(destinationEventListeners);
    }

    @Override
    public void setDestinations(List<Destination> destinations) {
        this._destinations.addAll(destinations);
    }

    @Override
    public void setMessageBusEventListeners(List<MessageBusEventListener> messageBusEventListeners) {
        this._messageBusEventListeners.addAll(messageBusEventListeners);
    }

    @Override
    public void setMessageListeners(Map<String, List<MessageListener>> messageListeners) {
        this._messageListeners.putAll(messageListeners);
    }

    protected ClassLoader getOperatingClassLoader() {
        Thread currentThread = Thread.currentThread();
        return currentThread.getContextClassLoader();
    }

    protected void initialize() {
        this.registerMessageBusEventListeners();
        this.registerDestinations();
        this.registerDestinationEventListeners();
        this.connect();
        String servletContextName = ServletContextClassLoaderPool.getServletContextName(this.getOperatingClassLoader());
        if (servletContextName != null) {
            MessagingConfiguratorRegistry.registerMessagingConfigurator(servletContextName, this);
        }
    }

    protected void registerDestinationEventListeners() {
        if (this._destinationEventListeners.isEmpty()) {
            return;
        }
        for (Map.Entry<String, List<DestinationEventListener>> entry : this._destinationEventListeners.entrySet()) {
            String destinationName = entry.getKey();
            ServiceLatch serviceLatch = SystemBundleUtil.newServiceLatch();
            serviceLatch.waitFor(StringBundler.concat((String[])new String[]{"(&(destination.name=", destinationName, ")(objectClass=", Destination.class.getName(), "))"}));
            serviceLatch.openOn(bundleContext -> {
                Dictionary<String, String> properties = MapUtil.singletonDictionary("destination.name", destinationName);
                for (DestinationEventListener destinationEventListener : (List)entry.getValue()) {
                    this._serviceRegistrations.add(bundleContext.registerService(DestinationEventListener.class, (Object)destinationEventListener, properties));
                }
            });
        }
    }

    protected void registerDestinations() {
        for (DestinationConfiguration destinationConfiguration : this._destinationConfigurations) {
            this._destinations.add(DestinationFactoryUtil.createDestination(destinationConfiguration));
        }
        if (this._destinations.isEmpty()) {
            return;
        }
        BundleContext bundleContext = SystemBundleUtil.getBundleContext();
        for (Destination destination : this._destinations) {
            this._serviceRegistrations.add(bundleContext.registerService(Destination.class, (Object)destination, MapUtil.singletonDictionary("destination.name", destination.getName())));
        }
    }

    protected void registerMessageBusEventListeners() {
        if (this._messageBusEventListeners.isEmpty()) {
            return;
        }
        BundleContext bundleContext = SystemBundleUtil.getBundleContext();
        for (MessageBusEventListener messageBusEventListener : this._messageBusEventListeners) {
            this._serviceRegistrations.add(bundleContext.registerService(MessageBusEventListener.class, (Object)messageBusEventListener, null));
        }
    }
}

