/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging.proxy;

import com.liferay.petra.reflect.AnnotationLocator;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.messaging.proxy.MessagingProxy;
import com.liferay.portal.kernel.messaging.proxy.ProxyMode;
import com.liferay.portal.kernel.util.MethodKey;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ProxyRequest
implements Externalizable {
    private static final Map<Method, boolean[]> _localAndSynchronousMap = new ConcurrentHashMap<Method, boolean[]>();
    private Object[] _arguments;
    private boolean _local;
    private Method _method;
    private boolean _synchronous;

    public ProxyRequest() {
        this._local = false;
    }

    public ProxyRequest(Method method, Object[] arguments) throws Exception {
        this._method = method;
        this._arguments = arguments;
        boolean[] localAndSynchronous = _localAndSynchronousMap.get(method);
        if (localAndSynchronous == null) {
            localAndSynchronous = new boolean[2];
            MessagingProxy messagingProxy = (MessagingProxy)AnnotationLocator.locate((Method)method, method.getDeclaringClass(), MessagingProxy.class);
            if (messagingProxy != null) {
                ProxyMode proxyMode;
                if (messagingProxy.local()) {
                    localAndSynchronous[0] = true;
                }
                if ((proxyMode = messagingProxy.mode()).equals((Object)ProxyMode.SYNC)) {
                    localAndSynchronous[1] = true;
                }
            }
            _localAndSynchronousMap.put(method, localAndSynchronous);
        }
        this._local = localAndSynchronous[0];
        this._synchronous = localAndSynchronous[1];
    }

    public Object execute(Object object) throws Exception {
        try {
            return this._method.invoke(object, this._arguments);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            throw new Exception(throwable);
        }
    }

    public Object[] getArguments() {
        return this._arguments;
    }

    public boolean hasReturnValue() {
        return this._method.getReturnType() != Void.TYPE;
    }

    public boolean isLocal() {
        return this._local;
    }

    public boolean isSynchronous() {
        return this._synchronous;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        this._arguments = (Object[])objectInput.readObject();
        this._local = objectInput.readBoolean();
        MethodKey methodKey = (MethodKey)objectInput.readObject();
        try {
            this._method = methodKey.getMethod();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IOException(noSuchMethodException);
        }
        this._synchronous = objectInput.readBoolean();
    }

    public String toString() {
        return StringBundler.concat((Object[])new Object[]{"{arguments=", Arrays.toString(this._arguments), ", local", this._local, ", method=", this._method, ", synchronous", this._synchronous, "}"});
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this._arguments);
        objectOutput.writeBoolean(this._local);
        objectOutput.writeObject(new MethodKey(this._method));
        objectOutput.writeBoolean(this._synchronous);
    }
}

