/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.model;

import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutBranch;
import com.liferay.portal.kernel.model.LayoutRevision;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetBranch;
import com.liferay.portal.kernel.model.LayoutType;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.WorkflowedModel;
import com.liferay.portal.kernel.service.LayoutBranchLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutRevisionLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetBranchLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.LayoutTypePortletFactoryUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;

public class LayoutStagingHandler
implements InvocationHandler,
Serializable {
    private static final Log _log = LogFactoryUtil.getLog(LayoutStagingHandler.class);
    private static final Function<InvocationHandler, Layout> _layoutProxyProviderFunction = ProxyUtil.getProxyProviderFunction(Layout.class);
    private static final Set<String> _layoutRevisionMethodNames = new HashSet<String>(Arrays.asList("getColorScheme", "getColorSchemeId", "getCss", "getCssText", "getDescription", "getGroupId", "getHTMLTitle", "getIconImage", "getIconImageId", "getKeywords", "getLayoutSet", "getModifiedDate", "getName", "getNameMap", "getRobots", "getTarget", "getTheme", "getThemeId", "getThemeSetting", "getTitle", "getTypeSettings", "getTypeSettingsProperties", "getTypeSettingsProperty", "isContentDisplayPage", "isCustomizable", "isEscapedModel", "isIconImage", "isInheritLookAndFeel", "setColorSchemeId", "setCss", "setDescription", "setDescriptionMap", "setEscapedModel", "setGroupId", "setIconImage", "setIconImageId", "setKeywords", "setKeywordsMap", "setModifiedDate", "setName", "setNameMap", "setRobots", "setRobotsMap", "setThemeId", "setTitle", "setTitleMap", "setTypeSettings", "setTypeSettingsProperties"));
    private final Layout _layout;
    private LayoutRevision _layoutRevision;

    public LayoutStagingHandler(Layout layout) {
        this(layout, null);
    }

    public Layout getLayout() {
        return this._layout;
    }

    public LayoutRevision getLayoutRevision() {
        return this._layoutRevision;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        try {
            String methodName = method.getName();
            if (methodName.equals("getWrappedModel")) {
                return this._layout;
            }
            if (this._layoutRevision == null) {
                return method.invoke((Object)this._layout, arguments);
            }
            if (methodName.equals("clone")) {
                return this._clone();
            }
            if (methodName.equals("getLayoutType")) {
                return this._getLayoutType();
            }
            if (methodName.equals("getRegularURL")) {
                Class<?> layoutRevisionClass = this._layoutRevision.getClass();
                method = layoutRevisionClass.getMethod(methodName, HttpServletRequest.class);
                return method.invoke((Object)this._layoutRevision, arguments);
            }
            if (methodName.equals("toEscapedModel")) {
                if (this._layout.isEscapedModel()) {
                    return this;
                }
                return this._toEscapedModel();
            }
            WorkflowedModel bean = this._layout;
            if (_layoutRevisionMethodNames.contains(methodName)) {
                try {
                    Class<?> layoutRevisionClass = this._layoutRevision.getClass();
                    method = layoutRevisionClass.getMethod(methodName, method.getParameterTypes());
                    bean = this._layoutRevision;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    _log.error(noSuchMethodException);
                }
            }
            return method.invoke((Object)bean, arguments);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
    }

    public void setLayoutRevision(LayoutRevision layoutRevision) {
        this._layoutRevision = layoutRevision;
    }

    private LayoutStagingHandler(Layout layout, LayoutRevision layoutRevision) {
        this._layout = layout;
        try {
            this._layoutRevision = this._getLayoutRevision(layout, layoutRevision);
        }
        catch (Exception exception) {
            _log.error(exception);
            throw new IllegalStateException(exception);
        }
    }

    private Object _clone() {
        return _layoutProxyProviderFunction.apply(new LayoutStagingHandler((Layout)this._layout.clone(), (LayoutRevision)this._layoutRevision.clone()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LayoutRevision _getLayoutRevision(Layout layout, LayoutRevision layoutRevision) throws PortalException {
        if (layoutRevision != null) {
            return layoutRevision;
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null || !serviceContext.isSignedIn()) {
            LayoutRevision lastLayoutRevision = LayoutRevisionLocalServiceUtil.fetchLastLayoutRevision(layout.getPlid(), true);
            if (lastLayoutRevision == null) {
                lastLayoutRevision = LayoutRevisionLocalServiceUtil.fetchLastLayoutRevision(layout.getPlid(), false);
            }
            return lastLayoutRevision;
        }
        User user = UserLocalServiceUtil.getUser(serviceContext.getUserId());
        long layoutSetBranchId = ParamUtil.getLong(serviceContext, "layoutSetBranchId");
        LayoutSet layoutSet = layout.getLayoutSet();
        LayoutSetBranch layoutSetBranch = LayoutSetBranchLocalServiceUtil.getUserLayoutSetBranch(serviceContext.getUserId(), layout.getGroupId(), layout.isPrivateLayout(), layoutSet.getLayoutSetId(), layoutSetBranchId);
        layoutSetBranchId = layoutSetBranch.getLayoutSetBranchId();
        long layoutRevisionId = ParamUtil.getLong(serviceContext, "layoutRevisionId");
        if (layoutRevisionId > 0L) {
            layoutRevision = LayoutRevisionLocalServiceUtil.fetchLayoutRevision(layoutRevisionId);
        }
        if (layoutRevisionId <= 0L || !this._isBelongsToLayout(layoutRevision, layout)) {
            layoutRevisionId = StagingUtil.getRecentLayoutRevisionId(user, layoutSetBranchId, layout.getPlid());
            layoutRevision = LayoutRevisionLocalServiceUtil.fetchLayoutRevision(layoutRevisionId);
        }
        if (layoutRevision == null || layoutRevision.isInactive()) {
            layoutRevision = LayoutRevisionLocalServiceUtil.fetchLatestLayoutRevision(layoutSetBranchId, layout.getPlid());
        }
        if (layoutRevision != null) {
            StagingUtil.setRecentLayoutRevisionId(user, layoutSetBranchId, layout.getPlid(), layoutRevision.getLayoutRevisionId());
            return layoutRevision;
        }
        LayoutBranch layoutBranch = LayoutBranchLocalServiceUtil.getMasterLayoutBranch(layoutSetBranchId, layout.getPlid(), serviceContext);
        int workflowAction = serviceContext.getWorkflowAction();
        try {
            serviceContext.setWorkflowAction(2);
            layoutRevision = LayoutRevisionLocalServiceUtil.addLayoutRevision(serviceContext.getUserId(), layoutSetBranchId, layoutBranch.getLayoutBranchId(), 0L, false, layout.getPlid(), 0L, layout.isPrivateLayout(), layout.getName(), layout.getTitle(), layout.getDescription(), layout.getKeywords(), layout.getRobots(), layout.getTypeSettings(), layout.getIconImage(), layout.getIconImageId(), layout.getThemeId(), layout.getColorSchemeId(), layout.getCss(), serviceContext);
        }
        finally {
            serviceContext.setWorkflowAction(workflowAction);
        }
        boolean explicitCreation = ParamUtil.getBoolean(serviceContext, "explicitCreation");
        if (!explicitCreation) {
            layoutRevision = LayoutRevisionLocalServiceUtil.updateStatus(serviceContext.getUserId(), layoutRevision.getLayoutRevisionId(), 6, serviceContext);
        }
        return layoutRevision;
    }

    private LayoutType _getLayoutType() {
        return LayoutTypePortletFactoryUtil.create(_layoutProxyProviderFunction.apply(new LayoutStagingHandler(this._layout, this._layoutRevision)));
    }

    private boolean _isBelongsToLayout(LayoutRevision layoutRevision, Layout layout) {
        if (layoutRevision == null) {
            return false;
        }
        return layoutRevision.getPlid() == layout.getPlid();
    }

    private Object _toEscapedModel() {
        return _layoutProxyProviderFunction.apply(new LayoutStagingHandler((Layout)this._layout.toEscapedModel(), (LayoutRevision)this._layoutRevision.toEscapedModel()));
    }
}

