/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.model;

import com.liferay.portal.kernel.bean.ClassLoaderBeanHandler;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ModelListenerRegistrationUtil {
    private static final BundleContext _bundleContext = SystemBundleUtil.getBundleContext();
    private static final ConcurrentMap<Class<?>, List<ModelListener<?>>> _modelListeners = new ConcurrentHashMap();
    private static final Map<String, ServiceRegistration<?>> _serviceRegistrations = new ConcurrentHashMap();
    private static final ServiceTracker<ModelListener<?>, ModelListener<?>> _serviceTracker = new ServiceTracker(_bundleContext, SystemBundleUtil.createFilter("(objectClass=" + ModelListener.class.getName() + ")"), (ServiceTrackerCustomizer)new ModelListenerTrackerCustomizer());

    public static <T> ModelListener<T>[] getModelListeners(Class<T> clazz) {
        List modelListeners = (List)_modelListeners.get(clazz);
        if (modelListeners == null) {
            return new ModelListener[0];
        }
        return modelListeners.toArray(new ModelListener[0]);
    }

    public static void register(ModelListener<?> modelListener) {
        Class<?> clazz = modelListener.getClass();
        ServiceRegistration serviceRegistration = _bundleContext.registerService(ModelListener.class.getName(), modelListener, null);
        _serviceRegistrations.put(clazz.getName(), serviceRegistration);
    }

    public static void unregister(ModelListener<?> modelListener) {
        Class<?> clazz = modelListener.getClass();
        ServiceRegistration<?> serviceRegistration = _serviceRegistrations.remove(clazz.getName());
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        }
    }

    static {
        _serviceTracker.open();
    }

    private static class ModelListenerTrackerCustomizer
    implements ServiceTrackerCustomizer<ModelListener<?>, ModelListener<?>> {
        private ModelListenerTrackerCustomizer() {
        }

        public ModelListener<?> addingService(ServiceReference<ModelListener<?>> serviceReference) {
            ModelListener modelListener = (ModelListener)_bundleContext.getService(serviceReference);
            Class<?> modelClass = this._getModelClass(modelListener);
            if (modelClass == null) {
                return null;
            }
            List<ModelListener<Object>> modelListeners = (ArrayList<ModelListener>)_modelListeners.get(modelClass);
            if (modelListeners == null) {
                modelListeners = new ArrayList<ModelListener>();
                List previousModelListeners = _modelListeners.putIfAbsent(modelClass, modelListeners);
                if (previousModelListeners != null) {
                    modelListeners = previousModelListeners;
                }
            }
            modelListeners.add(modelListener);
            return modelListener;
        }

        public void modifiedService(ServiceReference<ModelListener<?>> serviceReference, ModelListener<?> modelListener) {
        }

        public void removedService(ServiceReference<ModelListener<?>> serviceReference, ModelListener<?> modelListener) {
            _bundleContext.ungetService(serviceReference);
            Class<?> modelClass = this._getModelClass(modelListener);
            List modelListeners = (List)_modelListeners.get(modelClass);
            if (modelListeners != null) {
                modelListeners.remove(modelListener);
                if (modelListeners.isEmpty()) {
                    _modelListeners.remove(modelClass);
                }
            }
        }

        private Class<?> _getGenericSuperType(Class<?> clazz) {
            try {
                ParameterizedType parameterizedType = (ParameterizedType)clazz.getGenericSuperclass();
                Type[] types = parameterizedType.getActualTypeArguments();
                if (types.length > 0) {
                    return (Class)types[0];
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }

        private Class<?> _getModelClass(ModelListener<?> modelListener) {
            InvocationHandler invocationHandler;
            Class<?> clazz = modelListener.getModelClass();
            if (clazz != null) {
                return clazz;
            }
            clazz = modelListener.getClass();
            if (ProxyUtil.isProxyClass(clazz) && (invocationHandler = ProxyUtil.getInvocationHandler(modelListener)) instanceof ClassLoaderBeanHandler) {
                ClassLoaderBeanHandler classLoaderBeanHandler = (ClassLoaderBeanHandler)invocationHandler;
                Object bean = classLoaderBeanHandler.getBean();
                clazz = bean.getClass();
            }
            return this._getGenericSuperType(clazz);
        }
    }
}

