/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.poller;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.poller.DefaultPollerResponse;
import com.liferay.portal.kernel.poller.PollerHeader;
import com.liferay.portal.kernel.poller.PollerResponse;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class PollerRequest
implements Serializable {
    private final String _chunkId;
    private final Map<String, String> _parameterMap;
    private final PollerHeader _pollerHeader;
    private final String _portletId;
    private final boolean _receiveRequest;

    public PollerRequest(PollerHeader pollerHeader, String portletId, Map<String, String> parameterMap, String chunkId, boolean receiveRequest) {
        this._pollerHeader = pollerHeader;
        this._portletId = portletId;
        this._parameterMap = parameterMap;
        this._chunkId = chunkId;
        this._receiveRequest = receiveRequest;
    }

    public PollerResponse createPollerResponse() {
        return new DefaultPollerResponse();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PollerRequest)) {
            return false;
        }
        PollerRequest portletRequest = (PollerRequest)object;
        return Objects.equals(this._portletId, portletRequest._portletId);
    }

    public long getBrowserKey() {
        return this._pollerHeader.getBrowserKey();
    }

    public String getChunkId() {
        return this._chunkId;
    }

    public long getCompanyId() {
        return this._pollerHeader.getCompanyId();
    }

    public Map<String, String> getParameterMap() {
        return this._parameterMap;
    }

    public PollerHeader getPollerHeader() {
        return this._pollerHeader;
    }

    public String getPortletId() {
        return this._portletId;
    }

    public Set<String> getPortletIds() {
        Map<String, Boolean> portletIdsMap = this._pollerHeader.getPortletIdsMap();
        return portletIdsMap.keySet();
    }

    public long getTimestamp() {
        return this._pollerHeader.getTimestamp();
    }

    public long getUserId() {
        return this._pollerHeader.getUserId();
    }

    public int hashCode() {
        if (this._portletId != null) {
            return this._portletId.hashCode();
        }
        return 0;
    }

    public boolean isInitialRequest() {
        Map<String, Boolean> portletIdsMap = this._pollerHeader.getPortletIdsMap();
        return portletIdsMap.get(this._portletId);
    }

    public boolean isReceiveRequest() {
        return this._receiveRequest;
    }

    public boolean isStartPolling() {
        return this._pollerHeader.isStartPolling();
    }

    public String toString() {
        return StringBundler.concat((Object[])new Object[]{"{chunkId=", this._chunkId, ", parameterMap=", this._parameterMap, ", pollerHeader=", this._pollerHeader, ", portletId=", this._portletId, ", receiveRequest=", this._receiveRequest, "}"});
    }
}

