/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet;

import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.portlet.FriendlyURLResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class FriendlyURLResolverRegistryUtil {
    private static final BundleContext _bundleContext = SystemBundleUtil.getBundleContext();
    private static final ServiceTrackerMap<String, FriendlyURLResolver> _serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)_bundleContext, FriendlyURLResolver.class, null, (ServiceReferenceMapper)new ServiceReferenceMapper<String, FriendlyURLResolver>(){

        public void map(ServiceReference<FriendlyURLResolver> serviceReference, ServiceReferenceMapper.Emitter<String> emitter) {
            FriendlyURLResolver friendlyURLResolver = (FriendlyURLResolver)_bundleContext.getService(serviceReference);
            Class<?> friendlyURLResolverClass = friendlyURLResolver.getClass();
            emitter.emit((Object)friendlyURLResolverClass.getName());
            _bundleContext.ungetService(serviceReference);
        }
    });

    public static FriendlyURLResolver getFriendlyURLResolver(String urlSeparator) {
        for (String key : _serviceTrackerMap.keySet()) {
            FriendlyURLResolver friendlyURLResolver = (FriendlyURLResolver)_serviceTrackerMap.getService((Object)key);
            if (friendlyURLResolver == null || !Objects.equals(friendlyURLResolver.getURLSeparator(), urlSeparator)) continue;
            return friendlyURLResolver;
        }
        return null;
    }

    public static Collection<FriendlyURLResolver> getFriendlyURLResolversAsCollection() {
        ArrayList<FriendlyURLResolver> friendlyURLResolvers = new ArrayList<FriendlyURLResolver>();
        for (String key : _serviceTrackerMap.keySet()) {
            FriendlyURLResolver friendlyURLResolver = (FriendlyURLResolver)_serviceTrackerMap.getService((Object)key);
            if (friendlyURLResolver == null) continue;
            friendlyURLResolvers.add(friendlyURLResolver);
        }
        return friendlyURLResolvers;
    }

    public static String[] getURLSeparators() {
        ArrayList<String> urlSeparators = new ArrayList<String>();
        for (String key : _serviceTrackerMap.keySet()) {
            FriendlyURLResolver friendlyURLResolver = (FriendlyURLResolver)_serviceTrackerMap.getService((Object)key);
            if (friendlyURLResolver == null) continue;
            urlSeparators.add(friendlyURLResolver.getURLSeparator());
        }
        return urlSeparators.toArray(new String[0]);
    }
}

