/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet;

import com.liferay.portal.kernel.change.tracking.CTTransactionException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.portlet.LiferayPortletConfig;
import com.liferay.portal.kernel.portlet.LiferayPortletMode;
import com.liferay.portal.kernel.portlet.PortletResponseUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.MimeResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.WindowState;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletResponse;

public class LiferayPortlet
extends GenericPortlet {
    protected boolean addProcessActionSuccessMessage;
    protected boolean alwaysSendRedirect;
    private static final String[] _IGNORED_SESSION_MESSAGE_SUFFIXES = new String[]{".deleteSuccessData", ".forceSendRedirect", ".hideDefaultErrorMessage", ".hideDefaultSuccessMessage", ".refreshPortlet"};
    private static final Log _log = LogFactoryUtil.getLog(LiferayPortlet.class);
    private final Map<String, Method> _actionMethods = new ConcurrentHashMap<String, Method>();
    private final Map<String, Method> _resourceMethods = new ConcurrentHashMap<String, Method>();

    public void init() throws PortletException {
        super.init();
        this.addProcessActionSuccessMessage = GetterUtil.getBoolean(this.getInitParameter("add-process-action-success-action"), true);
        this.alwaysSendRedirect = GetterUtil.getBoolean(this.getInitParameter("always-send-redirect"));
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException, PortletException {
        try {
            if (!this.callActionMethod(actionRequest, actionResponse) || !SessionErrors.isEmpty((PortletRequest)actionRequest)) {
                return;
            }
            String portletId = PortalUtil.getPortletId((PortletRequest)actionRequest);
            if (!SessionMessages.contains((PortletRequest)actionRequest, portletId.concat(".forceSendRedirect")) && (this.isEmptySessionMessages(actionRequest) || this.isAlwaysSendRedirect())) {
                this.sendRedirect(actionRequest, actionResponse);
            }
            if (this.isAddSuccessMessage(actionRequest)) {
                this.addSuccessMessage(actionRequest, actionResponse);
            }
        }
        catch (PortletException portletException) {
            Throwable throwable = portletException.getCause();
            if (throwable instanceof CTTransactionException) {
                _log.error(throwable, throwable);
                SessionErrors.add(PortalUtil.getHttpServletRequest((PortletRequest)actionRequest), throwable.getClass(), (Object)throwable);
            }
            if (this.isSessionErrorException(throwable)) {
                if (_log.isDebugEnabled()) {
                    _log.debug(throwable, throwable);
                }
                SessionErrors.add((PortletRequest)actionRequest, throwable.getClass(), (Object)throwable);
            }
            if (_log.isDebugEnabled()) {
                _log.debug(portletException);
            }
            throw portletException;
        }
    }

    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException, PortletException {
        if (!(this.callResourceMethod(resourceRequest, resourceResponse) && SessionErrors.isEmpty((PortletRequest)resourceRequest) && SessionMessages.isEmpty((PortletRequest)resourceRequest))) {
            return;
        }
        super.serveResource(resourceRequest, resourceResponse);
    }

    protected void addSuccessMessage(ActionRequest actionRequest, ActionResponse actionResponse) {
        if (!this.addProcessActionSuccessMessage) {
            return;
        }
        String successMessage = ParamUtil.getString((PortletRequest)actionRequest, "successMessage");
        SessionMessages.add((PortletRequest)actionRequest, "requestProcessed", (Object)successMessage);
    }

    protected boolean callActionMethod(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException {
        String actionName = ParamUtil.getString((PortletRequest)actionRequest, "javax.portlet.action");
        if (Validator.isNull(actionName) || actionName.equals("callActionMethod") || actionName.equals("processAction")) {
            return false;
        }
        try {
            Method method = this.getActionMethod(actionName);
            method.invoke((Object)this, actionRequest, actionResponse);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (_log.isDebugEnabled()) {
                _log.debug(noSuchMethodException);
            }
            try {
                super.processAction(actionRequest, actionResponse);
                return true;
            }
            catch (Exception exception) {
                throw new PortletException((Throwable)exception);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable != null) {
                throw new PortletException(throwable);
            }
            throw new PortletException((Throwable)invocationTargetException);
        }
        catch (Exception exception) {
            throw new PortletException((Throwable)exception);
        }
    }

    protected boolean callResourceMethod(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws PortletException {
        String actionName = ParamUtil.getString((PortletRequest)resourceRequest, "javax.portlet.action");
        if (Validator.isNull(actionName) || actionName.equals("callResourceMethod") || actionName.equals("serveResource")) {
            return false;
        }
        try {
            Method method = this.getResourceMethod(actionName);
            method.invoke((Object)this, resourceRequest, resourceResponse);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (_log.isDebugEnabled()) {
                _log.debug(noSuchMethodException);
            }
            try {
                super.serveResource(resourceRequest, resourceResponse);
                return true;
            }
            catch (Exception exception) {
                throw new PortletException((Throwable)exception);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable != null) {
                throw new PortletException(throwable);
            }
            throw new PortletException((Throwable)invocationTargetException);
        }
        catch (Exception exception) {
            throw new PortletException((Throwable)exception);
        }
    }

    protected void doAbout(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        throw new PortletException("doAbout method not implemented");
    }

    protected void doConfig(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        throw new PortletException("doConfig method not implemented");
    }

    protected void doDispatch(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        WindowState windowState = renderRequest.getWindowState();
        if (windowState.equals((Object)WindowState.MINIMIZED)) {
            return;
        }
        PortletMode portletMode = renderRequest.getPortletMode();
        if (portletMode.equals((Object)PortletMode.VIEW)) {
            this.doView(renderRequest, renderResponse);
        } else if (portletMode.equals((Object)LiferayPortletMode.ABOUT)) {
            this.doAbout(renderRequest, renderResponse);
        } else if (portletMode.equals((Object)LiferayPortletMode.CONFIG)) {
            this.doConfig(renderRequest, renderResponse);
        } else if (portletMode.equals((Object)PortletMode.EDIT)) {
            this.doEdit(renderRequest, renderResponse);
        } else if (portletMode.equals((Object)LiferayPortletMode.EDIT_DEFAULTS)) {
            this.doEditDefaults(renderRequest, renderResponse);
        } else if (portletMode.equals((Object)LiferayPortletMode.EDIT_GUEST)) {
            this.doEditGuest(renderRequest, renderResponse);
        } else if (portletMode.equals((Object)PortletMode.HELP)) {
            this.doHelp(renderRequest, renderResponse);
        } else if (portletMode.equals((Object)LiferayPortletMode.PREVIEW)) {
            this.doPreview(renderRequest, renderResponse);
        } else if (portletMode.equals((Object)LiferayPortletMode.PRINT)) {
            this.doPrint(renderRequest, renderResponse);
        } else {
            throw new PortletException(portletMode.toString());
        }
    }

    protected void doEditDefaults(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        throw new PortletException("doEditDefaults method not implemented");
    }

    protected void doEditGuest(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        throw new PortletException("doEditGuest method not implemented");
    }

    protected void doPreview(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        throw new PortletException("doPreview method not implemented");
    }

    protected void doPrint(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        throw new PortletException("doPrint method not implemented");
    }

    protected Method getActionMethod(String actionName) throws NoSuchMethodException {
        Method method = this._actionMethods.get(actionName);
        if (method != null) {
            return method;
        }
        Class<?> clazz = ((Object)((Object)this)).getClass();
        method = clazz.getMethod(actionName, ActionRequest.class, ActionResponse.class);
        this._actionMethods.put(actionName, method);
        return method;
    }

    protected String getRedirect(ActionRequest actionRequest, ActionResponse actionResponse) {
        String redirect = (String)actionRequest.getAttribute("REDIRECT");
        if (Validator.isBlank(redirect) && !Validator.isBlank(redirect = ParamUtil.getString((PortletRequest)actionRequest, "redirect"))) {
            redirect = PortalUtil.escapeRedirect(redirect);
        }
        return redirect;
    }

    protected Method getResourceMethod(String actionName) throws NoSuchMethodException {
        Method method = this._resourceMethods.get(actionName);
        if (method != null) {
            return method;
        }
        Class<?> clazz = ((Object)((Object)this)).getClass();
        method = clazz.getMethod(actionName, ResourceRequest.class, ResourceResponse.class);
        this._resourceMethods.put(actionName, method);
        return method;
    }

    protected ServletContext getServletContext() {
        LiferayPortletConfig liferayPortletConfig = (LiferayPortletConfig)this.getPortletConfig();
        Portlet portlet = liferayPortletConfig.getPortlet();
        PortletApp portletApp = portlet.getPortletApp();
        return portletApp.getServletContext();
    }

    protected String getTitle(RenderRequest renderRequest) {
        try {
            return PortalUtil.getPortletTitle((PortletRequest)renderRequest);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug(exception);
            }
            return super.getTitle(renderRequest);
        }
    }

    protected boolean isAddSuccessMessage(ActionRequest actionRequest) {
        if (!this.addProcessActionSuccessMessage) {
            return false;
        }
        String portletId = PortalUtil.getPortletId((PortletRequest)actionRequest);
        if (SessionMessages.contains((PortletRequest)actionRequest, portletId.concat(".hideDefaultSuccessMessage"))) {
            return false;
        }
        if (SessionMessages.isEmpty((PortletRequest)actionRequest)) {
            return true;
        }
        int sessionMessagesSize = SessionMessages.size((PortletRequest)actionRequest);
        for (String suffix : _IGNORED_SESSION_MESSAGE_SUFFIXES) {
            if (!SessionMessages.contains((PortletRequest)actionRequest, portletId.concat(suffix))) continue;
            --sessionMessagesSize;
        }
        return sessionMessagesSize == 0;
    }

    protected boolean isAlwaysSendRedirect() {
        return this.alwaysSendRedirect;
    }

    protected boolean isEmptySessionMessages(ActionRequest actionRequest) {
        if (SessionMessages.isEmpty((PortletRequest)actionRequest)) {
            return true;
        }
        int sessionMessagesSize = SessionMessages.size((PortletRequest)actionRequest);
        String portletId = PortalUtil.getPortletId((PortletRequest)actionRequest);
        for (String suffix : _IGNORED_SESSION_MESSAGE_SUFFIXES) {
            if (!SessionMessages.contains((PortletRequest)actionRequest, portletId.concat(suffix))) continue;
            --sessionMessagesSize;
        }
        return sessionMessagesSize == 0;
    }

    protected boolean isSessionErrorException(Throwable throwable) {
        return throwable instanceof PortalException;
    }

    protected void sendRedirect(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException {
        String redirect = this.getRedirect(actionRequest, actionResponse);
        if (Validator.isNotNull(redirect)) {
            actionResponse.sendRedirect(redirect);
        }
    }

    protected String translate(PortletRequest portletRequest, String key) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return LanguageUtil.get(this.getResourceBundle(themeDisplay.getLocale()), key);
    }

    protected String translate(PortletRequest portletRequest, String key, Object ... arguments) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return LanguageUtil.format(this.getResourceBundle(themeDisplay.getLocale()), key, arguments);
    }

    protected void writeJSON(PortletRequest portletRequest, ActionResponse actionResponse, Object object) throws IOException {
        HttpServletResponse httpServletResponse = PortalUtil.getHttpServletResponse((PortletResponse)actionResponse);
        httpServletResponse.setContentType("application/json");
        ServletResponseUtil.write(httpServletResponse, this._toXSSSafeJSON(object.toString()));
        httpServletResponse.flushBuffer();
    }

    protected void writeJSON(PortletRequest portletRequest, MimeResponse mimeResponse, Object object) throws IOException {
        mimeResponse.setContentType("application/json");
        PortletResponseUtil.write(mimeResponse, this._toXSSSafeJSON(object.toString()));
        mimeResponse.flushBuffer();
    }

    private String _toXSSSafeJSON(String json) {
        return StringUtil.replace(json, '<', "\\u003c");
    }
}

