/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.portlet.PortletLayoutFinder;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.List;
import org.osgi.framework.BundleContext;

public class PortletLayoutFinderRegistryUtil {
    private static final Log _log = LogFactoryUtil.getLog(PortletLayoutFinderRegistryUtil.class);
    private static final ServiceTrackerMap<String, List<PortletLayoutFinder>> _serviceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)SystemBundleUtil.getBundleContext(), PortletLayoutFinder.class, (String)"(model.class.name=*)", (serviceReference, emitter) -> {
        for (String modelClassName : StringUtil.asList(serviceReference.getProperty("model.class.name"))) {
            emitter.emit((Object)modelClassName);
        }
    });

    public static PortletLayoutFinder getPortletLayoutFinder(String className) {
        List portletLayoutFinders = (List)_serviceTrackerMap.getService((Object)className);
        if (portletLayoutFinders == null) {
            return null;
        }
        return new CompositePortletLayoutFinder(portletLayoutFinders);
    }

    private static class CompositePortletLayoutFinder
    implements PortletLayoutFinder {
        private final Iterable<PortletLayoutFinder> _portletLayoutFinders;

        public CompositePortletLayoutFinder(Iterable<PortletLayoutFinder> portletLayoutFinders) {
            this._portletLayoutFinders = portletLayoutFinders;
        }

        @Override
        public PortletLayoutFinder.Result find(ThemeDisplay themeDisplay, long groupId) {
            block3: {
                try {
                    for (PortletLayoutFinder portletLayoutFinder : this._portletLayoutFinders) {
                        PortletLayoutFinder.Result result = portletLayoutFinder.find(themeDisplay, groupId);
                        if (result == null) continue;
                        return result;
                    }
                }
                catch (PortalException portalException) {
                    if (!_log.isDebugEnabled()) break block3;
                    _log.debug(portalException);
                }
            }
            return null;
        }
    }
}

