/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.impl.VirtualLayout;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactory;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.PortalUtil;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import javax.servlet.http.HttpServletRequest;

public class RequestBackedPortletURLFactoryUtil {
    private static final Log _log = LogFactoryUtil.getLog(RequestBackedPortletURLFactoryUtil.class);

    public static RequestBackedPortletURLFactory create(HttpServletRequest httpServletRequest) {
        return new HttpServletRequestRequestBackedPortletURLFactory(httpServletRequest);
    }

    public static RequestBackedPortletURLFactory create(PortletRequest portletRequest) {
        PortletResponse portletResponse = (PortletResponse)portletRequest.getAttribute("javax.portlet.response");
        if (portletResponse == null) {
            return RequestBackedPortletURLFactoryUtil.create(PortalUtil.getHttpServletRequest(portletRequest));
        }
        return new LiferayPortletResponseRequestBackedPortletURLFactory(PortalUtil.getLiferayPortletRequest(portletRequest), PortalUtil.getLiferayPortletResponse(portletResponse));
    }

    private static Layout _getControlPanelLayout(Layout controlPanelLayout, Group group) {
        if (controlPanelLayout == null) {
            return null;
        }
        if (group.isControlPanel()) {
            return controlPanelLayout;
        }
        return new VirtualLayout(controlPanelLayout, group);
    }

    private static PortletURL _populateControlPanelPortletURL(LiferayPortletURL liferayPortletURL, long refererGroupId, long refererPlid) {
        block4: {
            if (refererGroupId > 0L) {
                liferayPortletURL.setRefererGroupId(refererGroupId);
            }
            if (refererPlid > 0L) {
                liferayPortletURL.setRefererPlid(refererPlid);
            }
            try {
                liferayPortletURL.setWindowState(WindowState.MAXIMIZED);
            }
            catch (WindowStateException windowStateException) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug(windowStateException);
            }
        }
        return liferayPortletURL;
    }

    private static class LiferayPortletResponseRequestBackedPortletURLFactory
    implements RequestBackedPortletURLFactory {
        private final LiferayPortletRequest _liferayPortletRequest;
        private final LiferayPortletResponse _liferayPortletResponse;

        @Override
        public PortletURL createActionURL(String portletId) {
            return this._liferayPortletResponse.createActionURL(portletId);
        }

        @Override
        public PortletURL createControlPanelActionURL(String portletId, Group group, long refererGroupId, long refererPlid) {
            return this.createControlPanelPortletURL(portletId, group, refererGroupId, refererPlid, "ACTION_PHASE");
        }

        @Override
        public PortletURL createControlPanelPortletURL(String portletId, Group group, long refererGroupId, long refererPlid, String lifecycle) {
            Layout controlPanelLayout = null;
            ThemeDisplay themeDisplay = (ThemeDisplay)this._liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            if (themeDisplay != null) {
                controlPanelLayout = themeDisplay.getControlPanelLayout();
                if (group == null) {
                    group = themeDisplay.getScopeGroup();
                }
            }
            LiferayPortletURL liferayPortletURL = PortletURLFactoryUtil.create((PortletRequest)this._liferayPortletRequest, portletId, RequestBackedPortletURLFactoryUtil._getControlPanelLayout(controlPanelLayout, group), lifecycle);
            return RequestBackedPortletURLFactoryUtil._populateControlPanelPortletURL(liferayPortletURL, refererGroupId, refererPlid);
        }

        @Override
        public PortletURL createControlPanelRenderURL(String portletId, Group group, long refererGroupId, long refererPlid) {
            return this.createControlPanelPortletURL(portletId, group, refererGroupId, refererPlid, "RENDER_PHASE");
        }

        @Override
        public PortletURL createControlPanelResourceURL(String portletId, Group group, long refererGroupId, long refererPlid) {
            return this.createControlPanelPortletURL(portletId, group, refererGroupId, refererPlid, "RESOURCE_PHASE");
        }

        @Override
        public PortletURL createPortletURL(String portletId, String lifecycle) {
            return this._liferayPortletResponse.createLiferayPortletURL(portletId, lifecycle);
        }

        @Override
        public PortletURL createRenderURL(String portletId) {
            return this._liferayPortletResponse.createRenderURL(portletId);
        }

        @Override
        public PortletURL createResourceURL(String portletId) {
            return this._liferayPortletResponse.createResourceURL(portletId);
        }

        private LiferayPortletResponseRequestBackedPortletURLFactory(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
            this._liferayPortletRequest = liferayPortletRequest;
            this._liferayPortletResponse = liferayPortletResponse;
        }
    }

    private static class HttpServletRequestRequestBackedPortletURLFactory
    implements RequestBackedPortletURLFactory {
        private final HttpServletRequest _httpServletRequest;

        @Override
        public PortletURL createActionURL(String portletId) {
            String actionPhase = "ACTION_PHASE";
            return this.createPortletURL(portletId, actionPhase);
        }

        @Override
        public PortletURL createControlPanelActionURL(String portletId, Group group, long refererGroupId, long refererPlid) {
            return this.createControlPanelPortletURL(portletId, group, refererGroupId, refererPlid, "ACTION_PHASE");
        }

        @Override
        public PortletURL createControlPanelPortletURL(String portletId, Group group, long refererGroupId, long refererPlid, String lifecycle) {
            Layout controlPanelLayout = null;
            ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            if (themeDisplay != null) {
                controlPanelLayout = themeDisplay.getControlPanelLayout();
                if (group == null) {
                    group = themeDisplay.getScopeGroup();
                }
            }
            LiferayPortletURL liferayPortletURL = PortletURLFactoryUtil.create(this._httpServletRequest, portletId, RequestBackedPortletURLFactoryUtil._getControlPanelLayout(controlPanelLayout, group), lifecycle);
            return RequestBackedPortletURLFactoryUtil._populateControlPanelPortletURL(liferayPortletURL, refererGroupId, refererPlid);
        }

        @Override
        public PortletURL createControlPanelRenderURL(String portletId, Group group, long refererGroupId, long refererPlid) {
            return this.createControlPanelPortletURL(portletId, group, refererGroupId, refererPlid, "RENDER_PHASE");
        }

        @Override
        public PortletURL createControlPanelResourceURL(String portletId, Group group, long refererGroupId, long refererPlid) {
            return this.createControlPanelPortletURL(portletId, group, refererGroupId, refererPlid, "RESOURCE_PHASE");
        }

        @Override
        public PortletURL createPortletURL(String portletId, String lifecycle) {
            ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            return PortletURLFactoryUtil.create(this._httpServletRequest, portletId, themeDisplay.getPlid(), lifecycle);
        }

        @Override
        public PortletURL createRenderURL(String portletId) {
            return this.createPortletURL(portletId, "RENDER_PHASE");
        }

        @Override
        public PortletURL createResourceURL(String portletId) {
            return this.createPortletURL(portletId, "RESOURCE_PHASE");
        }

        private HttpServletRequestRequestBackedPortletURLFactory(HttpServletRequest httpServletRequest) {
            this._httpServletRequest = httpServletRequest;
        }
    }
}

