/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet.bridges.mvc;

import com.liferay.portal.kernel.portlet.bridges.mvc.MVCResourceCommand;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import java.util.concurrent.Callable;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;

public abstract class BaseTransactionalMVCResourceCommand
implements MVCResourceCommand {
    private static final TransactionConfig _transactionConfig;

    @Override
    public boolean serveResource(final ResourceRequest resourceRequest, final ResourceResponse resourceResponse) throws PortletException {
        try {
            Callable<Boolean> callable = new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    BaseTransactionalMVCResourceCommand.this.doTransactionalCommand(resourceRequest, resourceResponse);
                    return SessionErrors.isEmpty((PortletRequest)resourceRequest);
                }
            };
            return TransactionInvokerUtil.invoke(_transactionConfig, callable);
        }
        catch (Throwable throwable) {
            if (throwable instanceof PortletException) {
                throw (PortletException)throwable;
            }
            throw new PortletException(throwable);
        }
    }

    protected abstract void doTransactionalCommand(ResourceRequest var1, ResourceResponse var2) throws Exception;

    static {
        TransactionConfig.Builder builder = new TransactionConfig.Builder();
        builder.setPropagation(Propagation.REQUIRES_NEW);
        builder.setRollbackForClasses(Exception.class);
        _transactionConfig = builder.build();
    }
}

