/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet.toolbar;

import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.portlet.toolbar.contributor.PortletToolbarContributor;
import com.liferay.portal.kernel.portlet.toolbar.contributor.locator.PortletToolbarContributorLocator;
import com.liferay.portal.kernel.servlet.taglib.ui.Menu;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import org.osgi.framework.BundleContext;

public class PortletToolbar {
    private static final ServiceTrackerList<PortletToolbarContributorLocator> _portletToolbarContributorLocators = ServiceTrackerListFactory.open((BundleContext)SystemBundleUtil.getBundleContext(), PortletToolbarContributorLocator.class);

    public List<Menu> getPortletTitleMenus(String portletId, PortletRequest portletRequest, PortletResponse portletResponse) {
        if (portletRequest == null || portletResponse == null || Validator.isNull(portletId)) {
            return Collections.emptyList();
        }
        HttpServletRequest originalHttpServletRequest = PortalUtil.getOriginalServletRequest(PortalUtil.getHttpServletRequest(portletRequest));
        String layoutMode = ParamUtil.getString(originalHttpServletRequest, "p_l_mode", "view");
        ArrayList<Menu> portletTitleMenus = new ArrayList<Menu>();
        for (PortletToolbarContributorLocator portletToolbarContributorLocator : _portletToolbarContributorLocators) {
            List<PortletToolbarContributor> portletToolbarContributors = portletToolbarContributorLocator.getPortletToolbarContributors(portletId, portletRequest);
            if (portletToolbarContributors == null) continue;
            for (PortletToolbarContributor portletToolbarContributor : portletToolbarContributors) {
                List<Menu> curPortletTitleMenus;
                if (Objects.equals(layoutMode, "edit") && !portletToolbarContributor.isShowInEditMode() || ListUtil.isEmpty(curPortletTitleMenus = portletToolbarContributor.getPortletTitleMenus(portletRequest, portletResponse))) continue;
                portletTitleMenus.addAll(curPortletTitleMenus);
            }
        }
        return portletTitleMenus;
    }
}

