/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet.url.builder;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.util.Validator;
import javax.portlet.MimeResponse;
import javax.portlet.MutableResourceParameters;
import javax.portlet.PortletParameters;
import javax.portlet.PortletSecurityException;
import javax.portlet.ResourceURL;

public class ResourceURLBuilder {
    public static ResourceURLStep createResourceURL(LiferayPortletResponse liferayPortletResponse) {
        return new ResourceURLStep(liferayPortletResponse.createResourceURL());
    }

    public static ResourceURLStep createResourceURL(LiferayPortletResponse liferayPortletResponse, String portletName) {
        return new ResourceURLStep(liferayPortletResponse.createResourceURL(portletName));
    }

    public static ResourceURLStep createResourceURL(MimeResponse mimeResponse) {
        return new ResourceURLStep(mimeResponse.createResourceURL());
    }

    public static ResourceURLStep createResourceURL(ResourceURL resourceURL) {
        return new ResourceURLStep(resourceURL);
    }

    @FunctionalInterface
    public static interface UnsafeSupplier<T, E extends Throwable> {
        public T get() throws E;
    }

    public static interface Tabs2Step {
        public AfterTabs2Step setTabs2(String var1);

        public AfterTabs2Step setTabs2(UnsafeSupplier<Object, Exception> var1);
    }

    public static interface Tabs1Step {
        public AfterTabs1Step setTabs1(String var1);

        public AfterTabs1Step setTabs1(UnsafeSupplier<Object, Exception> var1);
    }

    public static interface SecureStep {
        public AfterSecureStep setSecure(boolean var1);
    }

    public static interface ResourceIDStep {
        public AfterResourceIDStep setResourceID(String var1);
    }

    public static interface RedirectStep {
        public AfterRedirectStep setRedirect(Object var1);

        public AfterRedirectStep setRedirect(String var1);

        public AfterRedirectStep setRedirect(UnsafeSupplier<Object, Exception> var1);
    }

    public static interface PortletResourceStep {
        public AfterPortletResourceStep setPortletResource(String var1);

        public AfterPortletResourceStep setPortletResource(UnsafeSupplier<Object, Exception> var1);
    }

    public static interface ParameterStep {
        public AfterParameterStep removeParameter(String var1);

        public AfterParameterStep setParameter(String var1, Object var2);

        public AfterParameterStep setParameter(String var1, Object var2, boolean var3);

        public AfterParameterStep setParameter(String var1, String var2);

        public AfterParameterStep setParameter(String var1, String ... var2);

        public AfterParameterStep setParameter(String var1, String var2, boolean var3);

        public AfterParameterStep setParameter(String var1, UnsafeSupplier<Object, Exception> var2);

        public AfterParameterStep setParameters(PortletParameters var1);
    }

    public static interface NavigationStep {
        public AfterNavigationStep setNavigation(String var1);

        public AfterNavigationStep setNavigation(UnsafeSupplier<Object, Exception> var1);
    }

    public static interface MVCResourceCommandNameStep {
        public AfterMVCResourceCommandNameStep setMVCResourceCommandName(String var1);

        public AfterMVCResourceCommandNameStep setMVCResourceCommandName(String var1, boolean var2);

        public AfterMVCResourceCommandNameStep setMVCResourceCommandName(UnsafeSupplier<Object, Exception> var1);
    }

    public static interface MVCPathStep {
        public AfterMVCPathStep setMVCPath(String var1);

        public AfterMVCPathStep setMVCPath(UnsafeSupplier<Object, Exception> var1);
    }

    public static interface KeywordsStep {
        public AfterKeywordsStep setKeywords(String var1);

        public AfterKeywordsStep setKeywords(UnsafeSupplier<Object, Exception> var1);
    }

    public static interface CMDStep {
        public AfterCMDStep setCMD(String var1);

        public AfterCMDStep setCMD(UnsafeSupplier<Object, Exception> var1);
    }

    public static interface CacheabilityStep {
        public AfterCacheabilityStep setCacheability(String var1);
    }

    public static interface BuildStep {
        public ResourceURL buildResourceURL();

        public String buildString();
    }

    public static interface BackURLStep {
        public AfterBackURLStep setBackURL(String var1);

        public AfterBackURLStep setBackURL(UnsafeSupplier<Object, Exception> var1);
    }

    public static interface AfterTabs2Step
    extends BuildStep,
    CacheabilityStep,
    ParameterStep,
    ResourceIDStep,
    SecureStep {
    }

    public static interface AfterTabs1Step
    extends BuildStep,
    CacheabilityStep,
    ParameterStep,
    ResourceIDStep,
    SecureStep,
    Tabs2Step {
    }

    public static interface AfterSecureStep
    extends BuildStep {
    }

    public static interface AfterResourceIDStep
    extends BuildStep,
    SecureStep {
    }

    public static interface AfterRedirectStep
    extends BackURLStep,
    BuildStep,
    CacheabilityStep,
    KeywordsStep,
    NavigationStep,
    ParameterStep,
    PortletResourceStep,
    ResourceIDStep,
    SecureStep,
    Tabs1Step,
    Tabs2Step {
    }

    public static interface AfterPortletResourceStep
    extends BuildStep,
    CacheabilityStep,
    ParameterStep,
    ResourceIDStep,
    SecureStep,
    Tabs1Step,
    Tabs2Step {
    }

    public static interface AfterParameterStep
    extends BuildStep,
    CacheabilityStep,
    ParameterStep,
    ResourceIDStep,
    SecureStep {
    }

    public static interface AfterNavigationStep
    extends BuildStep,
    CacheabilityStep,
    ParameterStep,
    PortletResourceStep,
    ResourceIDStep,
    SecureStep,
    Tabs1Step,
    Tabs2Step {
    }

    public static interface AfterMVCResourceCommandNameStep
    extends BackURLStep,
    BuildStep,
    CacheabilityStep,
    CMDStep,
    KeywordsStep,
    NavigationStep,
    ParameterStep,
    PortletResourceStep,
    RedirectStep,
    ResourceIDStep,
    SecureStep,
    Tabs1Step,
    Tabs2Step {
    }

    public static interface AfterMVCPathStep
    extends BackURLStep,
    BuildStep,
    CacheabilityStep,
    CMDStep,
    KeywordsStep,
    MVCResourceCommandNameStep,
    NavigationStep,
    ParameterStep,
    PortletResourceStep,
    RedirectStep,
    ResourceIDStep,
    SecureStep,
    Tabs1Step,
    Tabs2Step {
    }

    public static interface AfterKeywordsStep
    extends BuildStep,
    CacheabilityStep,
    NavigationStep,
    ParameterStep,
    PortletResourceStep,
    ResourceIDStep,
    SecureStep,
    Tabs1Step,
    Tabs2Step {
    }

    public static interface AfterCMDStep
    extends BackURLStep,
    BuildStep,
    CacheabilityStep,
    KeywordsStep,
    NavigationStep,
    ParameterStep,
    PortletResourceStep,
    RedirectStep,
    ResourceIDStep,
    SecureStep,
    Tabs1Step,
    Tabs2Step {
    }

    public static interface AfterCacheabilityStep
    extends BuildStep,
    ResourceIDStep,
    SecureStep {
    }

    public static interface AfterBackURLStep
    extends BuildStep,
    CacheabilityStep,
    KeywordsStep,
    NavigationStep,
    ParameterStep,
    PortletResourceStep,
    ResourceIDStep,
    SecureStep,
    Tabs1Step,
    Tabs2Step {
    }

    public static class ResourceURLStep
    implements AfterBackURLStep,
    AfterCacheabilityStep,
    AfterCMDStep,
    AfterKeywordsStep,
    AfterMVCPathStep,
    AfterMVCResourceCommandNameStep,
    AfterNavigationStep,
    AfterParameterStep,
    AfterPortletResourceStep,
    AfterRedirectStep,
    AfterResourceIDStep,
    AfterSecureStep,
    AfterTabs1Step,
    AfterTabs2Step,
    BackURLStep,
    BuildStep,
    CacheabilityStep,
    CMDStep,
    KeywordsStep,
    MVCPathStep,
    MVCResourceCommandNameStep,
    NavigationStep,
    ParameterStep,
    PortletResourceStep,
    RedirectStep,
    ResourceIDStep,
    SecureStep,
    Tabs1Step,
    Tabs2Step {
        private static final String[][] _RESERVED_KEYWORDS = new String[][]{{"cmd", "setCMD"}, {"backURL", "setBackURL"}, {"keywords", "setKeywords"}, {"mvcPath", "setMVCPath"}, {"mvcResourceCommandName", "setMVCResourceCommandName"}, {"navigation", "setNavigation"}, {"portletResource", "setPortletResource"}, {"redirect", "setRedirect"}, {"tabs1", "setTabs1"}, {"tabs2", "setTabs2"}};
        private final ResourceURL _resourceURL;

        public ResourceURLStep(ResourceURL resourceURL) {
            this._resourceURL = resourceURL;
        }

        @Override
        public ResourceURL buildResourceURL() {
            return this._resourceURL;
        }

        @Override
        public String buildString() {
            return this._resourceURL.toString();
        }

        @Override
        public AfterParameterStep removeParameter(String name) {
            MutableResourceParameters mutableResourceParameters = this._resourceURL.getResourceParameters();
            mutableResourceParameters.removeParameter(name);
            return this;
        }

        @Override
        public AfterBackURLStep setBackURL(String value) {
            this._setParameter("backURL", value, false);
            return this;
        }

        @Override
        public AfterBackURLStep setBackURL(UnsafeSupplier<Object, Exception> valueUnsafeSupplier) {
            this._setParameter("backURL", valueUnsafeSupplier, false);
            return this;
        }

        @Override
        public AfterCacheabilityStep setCacheability(String cacheLevel) {
            this._resourceURL.setCacheability(cacheLevel);
            return this;
        }

        @Override
        public AfterCMDStep setCMD(String value) {
            this._setParameter("cmd", value, false);
            return this;
        }

        @Override
        public AfterCMDStep setCMD(UnsafeSupplier<Object, Exception> valueUnsafeSupplier) {
            this._setParameter("cmd", valueUnsafeSupplier, false);
            return this;
        }

        @Override
        public AfterKeywordsStep setKeywords(String value) {
            this._setParameter("keywords", value, false);
            return this;
        }

        @Override
        public AfterKeywordsStep setKeywords(UnsafeSupplier<Object, Exception> valueUnsafeSupplier) {
            this._setParameter("keywords", valueUnsafeSupplier, false);
            return this;
        }

        @Override
        public AfterMVCPathStep setMVCPath(String value) {
            this._setParameter("mvcPath", value, false);
            return this;
        }

        @Override
        public AfterMVCPathStep setMVCPath(UnsafeSupplier<Object, Exception> valueUnsafeSupplier) {
            this._setParameter("mvcPath", valueUnsafeSupplier, false);
            return this;
        }

        @Override
        public AfterMVCResourceCommandNameStep setMVCResourceCommandName(String value) {
            this._setParameter("mvcResourceCommandName", value, false);
            return this;
        }

        @Override
        public AfterMVCResourceCommandNameStep setMVCResourceCommandName(String value, boolean allowNullValue) {
            if (allowNullValue || Validator.isNotNull(value)) {
                this._setParameter("mvcResourceCommandName", value, false);
            }
            return this;
        }

        @Override
        public AfterMVCResourceCommandNameStep setMVCResourceCommandName(UnsafeSupplier<Object, Exception> valueUnsafeSupplier) {
            this._setParameter("mvcResourceCommandName", valueUnsafeSupplier, false);
            return this;
        }

        @Override
        public AfterNavigationStep setNavigation(String value) {
            this._setParameter("navigation", value, false);
            return this;
        }

        @Override
        public AfterNavigationStep setNavigation(UnsafeSupplier<Object, Exception> valueUnsafeSupplier) {
            this._setParameter("navigation", valueUnsafeSupplier, false);
            return this;
        }

        @Override
        public AfterParameterStep setParameter(String key, Object value) {
            this._setParameter(key, String.valueOf(value), true);
            return this;
        }

        @Override
        public AfterParameterStep setParameter(String name, Object value, boolean allowNullValue) {
            this.setParameter(name, String.valueOf(value), allowNullValue);
            return this;
        }

        @Override
        public AfterParameterStep setParameter(String key, String value) {
            this._setParameter(key, value, true);
            return this;
        }

        @Override
        public AfterParameterStep setParameter(String key, String ... values) {
            MutableResourceParameters mutableResourceParameters = this._resourceURL.getResourceParameters();
            mutableResourceParameters.setValues(key, values);
            return this;
        }

        @Override
        public AfterParameterStep setParameter(String name, String value, boolean allowNullValue) {
            if (allowNullValue || Validator.isNotNull(value)) {
                this._setParameter(name, value, true);
            }
            return this;
        }

        @Override
        public AfterParameterStep setParameter(String key, UnsafeSupplier<Object, Exception> valueUnsafeSupplier) {
            this._setParameter(key, valueUnsafeSupplier, true);
            return this;
        }

        @Override
        public AfterParameterStep setParameters(PortletParameters portletParameters) {
            MutableResourceParameters mutableResourceParameters = this._resourceURL.getResourceParameters();
            mutableResourceParameters.set(portletParameters);
            return this;
        }

        @Override
        public AfterPortletResourceStep setPortletResource(String value) {
            this._setParameter("portletResource", value, false);
            return this;
        }

        @Override
        public AfterPortletResourceStep setPortletResource(UnsafeSupplier<Object, Exception> valueUnsafeSupplier) {
            this._setParameter("portletResource", valueUnsafeSupplier, false);
            return this;
        }

        @Override
        public AfterRedirectStep setRedirect(Object value) {
            this._setParameter("redirect", String.valueOf(value), false);
            return this;
        }

        @Override
        public AfterRedirectStep setRedirect(String value) {
            this._setParameter("redirect", value, false);
            return this;
        }

        @Override
        public AfterRedirectStep setRedirect(UnsafeSupplier<Object, Exception> valueUnsafeSupplier) {
            this._setParameter("redirect", valueUnsafeSupplier, false);
            return this;
        }

        @Override
        public AfterResourceIDStep setResourceID(String resourceID) {
            this._resourceURL.setResourceID(resourceID);
            return this;
        }

        @Override
        public AfterSecureStep setSecure(boolean secure) {
            try {
                this._resourceURL.setSecure(secure);
            }
            catch (PortletSecurityException portletSecurityException) {
                throw new SystemException(portletSecurityException);
            }
            return this;
        }

        @Override
        public AfterTabs1Step setTabs1(String value) {
            this._setParameter("tabs1", value, false);
            return this;
        }

        @Override
        public AfterTabs1Step setTabs1(UnsafeSupplier<Object, Exception> valueUnsafeSupplier) {
            this._setParameter("tabs1", valueUnsafeSupplier, false);
            return this;
        }

        @Override
        public AfterTabs2Step setTabs2(String value) {
            this._setParameter("tabs2", value, false);
            return this;
        }

        @Override
        public AfterTabs2Step setTabs2(UnsafeSupplier<Object, Exception> valueUnsafeSupplier) {
            this._setParameter("tabs2", valueUnsafeSupplier, false);
            return this;
        }

        private void _setParameter(String key, String value, boolean validateKey) {
            if (validateKey) {
                this._validateKey(key);
            }
            MutableResourceParameters mutableResourceParameters = this._resourceURL.getResourceParameters();
            mutableResourceParameters.setValue(key, value);
        }

        private void _setParameter(String key, UnsafeSupplier<Object, Exception> valueUnsafeSupplier, boolean validateKey) {
            if (validateKey) {
                this._validateKey(key);
            }
            try {
                Object value = valueUnsafeSupplier.get();
                if (value == null) {
                    return;
                }
                MutableResourceParameters mutableResourceParameters = this._resourceURL.getResourceParameters();
                if (value instanceof String[]) {
                    mutableResourceParameters.setValues(key, (String[])value);
                } else {
                    mutableResourceParameters.setValue(key, String.valueOf(value));
                }
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        private void _validateKey(String key) {
            if (key == null) {
                return;
            }
            for (String[] reservedKeywordArray : _RESERVED_KEYWORDS) {
                String reservedKey = reservedKeywordArray[0];
                if (!key.equals(reservedKey)) continue;
                throw new RuntimeException(StringBundler.concat((String[])new String[]{"Use method \"", reservedKeywordArray[1], "\" when setting value for \"", reservedKey, "\""}));
            }
        }
    }
}

