/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.repository.model;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;

public class FileContentReference {
    private final String _extension;
    private final File _file;
    private final long _fileEntryId;
    private final long _groupId;
    private final InputStream _inputStream;
    private final String _mimeType;
    private final long _size;
    private final String _sourceFileName;

    public static FileContentReference fromBytes(long groupId, long fileEntryId, String sourceFileName, String extension, String mimeType, byte[] bytes) {
        return FileContentReference.fromInputStream(groupId, fileEntryId, sourceFileName, extension, mimeType, new ByteArrayInputStream(bytes), bytes.length);
    }

    public static FileContentReference fromBytes(long groupId, String sourceFileName, String extension, String mimeType, byte[] bytes) {
        return FileContentReference.fromInputStream(groupId, 0L, sourceFileName, extension, mimeType, new ByteArrayInputStream(bytes), bytes.length);
    }

    public static FileContentReference fromFile(long groupId, long fileEntryId, String sourceFileName, String extension, String mimeType, File file) {
        return new FileContentReference(groupId, fileEntryId, sourceFileName, extension, mimeType, file, null, 0L);
    }

    public static FileContentReference fromFile(long groupId, String sourceFileName, String extension, String mimeType, File file) {
        return FileContentReference.fromFile(groupId, 0L, sourceFileName, extension, mimeType, file);
    }

    public static FileContentReference fromInputStream(long groupId, long fileEntryId, String sourceFileName, String extension, String mimeType, InputStream inputStream, long size) {
        return new FileContentReference(groupId, fileEntryId, sourceFileName, extension, mimeType, null, inputStream, size);
    }

    public static FileContentReference fromInputStream(long groupId, String sourceFileName, String extension, String mimeType, InputStream inputStream, long size) {
        return FileContentReference.fromInputStream(groupId, 0L, sourceFileName, extension, mimeType, inputStream, size);
    }

    public String getExtension() {
        return this._extension;
    }

    public long getFileEntryId() {
        return this._fileEntryId;
    }

    public long getGroupId() {
        return this._groupId;
    }

    public String getMimeType() {
        return this._mimeType;
    }

    public long getSize() {
        if (this._inputStream != null) {
            return this._size;
        }
        if (this._file != null) {
            return this._file.length();
        }
        return 0L;
    }

    public String getSourceFileName() {
        return this._sourceFileName;
    }

    private FileContentReference(long groupId, long fileEntryId, String sourceFileName, String extension, String mimeType, File file, InputStream inputStream, long size) {
        this._groupId = groupId;
        this._fileEntryId = fileEntryId;
        this._sourceFileName = sourceFileName;
        this._extension = extension;
        this._mimeType = mimeType;
        this._file = file;
        this._inputStream = inputStream;
        this._size = size;
    }
}

