/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search.queue;

import com.liferay.portal.kernel.search.BaseSearchEngine;
import com.liferay.portal.kernel.search.IndexSearcher;
import com.liferay.portal.kernel.search.IndexWriter;
import com.liferay.portal.kernel.search.dummy.DummyIndexSearcher;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.QueuingInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.util.function.Function;

public class QueuingSearchEngine
extends BaseSearchEngine {
    private static final Function<InvocationHandler, IndexWriter> _indexWriterProxyProviderFunction = ProxyUtil.getProxyProviderFunction(IndexWriter.class);
    private final IndexSearcher _indexSearcher = new DummyIndexSearcher();
    private final IndexWriter _indexWriter;
    private final QueuingInvocationHandler _queuingInvocationHandler;

    public QueuingSearchEngine(int capacity) {
        this._queuingInvocationHandler = new QueuingInvocationHandler(capacity);
        this._indexWriter = _indexWriterProxyProviderFunction.apply(this._queuingInvocationHandler);
    }

    public void flush() {
        this._queuingInvocationHandler.flush();
    }

    @Override
    public IndexSearcher getIndexSearcher() {
        return this._indexSearcher;
    }

    @Override
    public IndexWriter getIndexWriter() {
        return this._indexWriter;
    }

    public void invokeQueued(IndexWriter indexWriter) throws Exception {
        this._queuingInvocationHandler.invokeQueued(indexWriter);
    }
}

