/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.permission;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.security.permission.BaseModelPermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionUtil;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import org.osgi.framework.BundleContext;

public class BaseModelPermissionCheckerUtil {
    private static final Log _log = LogFactoryUtil.getLog(BaseModelPermissionCheckerUtil.class);
    private static final ServiceTrackerMap<String, BaseModelPermissionChecker> _baseModelPermissionCheckers = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)SystemBundleUtil.getBundleContext(), BaseModelPermissionChecker.class, (String)"model.class.name");
    private static final ServiceTrackerMap<String, ModelResourcePermission<?>> _modelPermissions = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)SystemBundleUtil.getBundleContext(), ModelResourcePermission.class, (String)"model.class.name");

    public static Boolean containsBaseModelPermission(PermissionChecker permissionChecker, long groupId, String className, long classPK, String actionId) {
        ModelResourcePermission modelResourcePermission = (ModelResourcePermission)_modelPermissions.getService((Object)className);
        if (modelResourcePermission != null) {
            try {
                PortletResourcePermission portletResourcePermission = modelResourcePermission.getPortletResourcePermission();
                if (portletResourcePermission == null) {
                    return modelResourcePermission.contains(permissionChecker, classPK, actionId);
                }
                return ModelResourcePermissionUtil.contains(modelResourcePermission, permissionChecker, groupId, classPK, actionId);
            }
            catch (PortalException portalException) {
                if (_log.isWarnEnabled()) {
                    _log.warn(portalException);
                }
                return false;
            }
        }
        BaseModelPermissionChecker baseModelPermissionChecker = (BaseModelPermissionChecker)_baseModelPermissionCheckers.getService((Object)className);
        if (baseModelPermissionChecker == null) {
            return null;
        }
        try {
            baseModelPermissionChecker.checkBaseModel(permissionChecker, groupId, classPK, actionId);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug(exception);
            }
            return false;
        }
        return true;
    }
}

