/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.pwd;

import com.liferay.portal.kernel.exception.PwdEncryptorException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pwd.PasswordEncryptor;
import com.liferay.portal.kernel.util.ServiceProxyFactory;

public class PasswordEncryptorUtil {
    private static final Log _log = LogFactoryUtil.getLog(PasswordEncryptorUtil.class);
    private static volatile PasswordEncryptor _passwordEncryptor = ServiceProxyFactory.newServiceTrackedInstance(PasswordEncryptor.class, PasswordEncryptorUtil.class, "_passwordEncryptor", "(composite=true)", true);

    public static String encrypt(String plainTextPassword) throws PwdEncryptorException {
        return PasswordEncryptorUtil.encrypt(plainTextPassword, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encrypt(String plainTextPassword, String encryptedPassword) throws PwdEncryptorException {
        long startTime = 0L;
        if (_log.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
        }
        try {
            String string = _passwordEncryptor.encrypt(plainTextPassword, encryptedPassword);
            return string;
        }
        finally {
            if (_log.isDebugEnabled()) {
                _log.debug("Password encrypted in " + (System.currentTimeMillis() - startTime) + "ms");
            }
        }
    }

    public static String encrypt(String algorithm, String plainTextPassword, String encryptedPassword) throws PwdEncryptorException {
        return _passwordEncryptor.encrypt(algorithm, plainTextPassword, encryptedPassword);
    }

    public static String getDefaultPasswordAlgorithmType() {
        return _passwordEncryptor.getDefaultPasswordAlgorithmType();
    }
}

