/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.servlet.PortalWebResourcesUtil;
import com.liferay.portal.kernel.util.Validator;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import org.osgi.framework.BundleContext;

public class DynamicResourceIncludeUtil {
    private static final Log _log = LogFactoryUtil.getLog(DynamicResourceIncludeUtil.class);
    private static final ServiceTrackerList<ServletContext> _servletContexts = ServiceTrackerListFactory.open((BundleContext)SystemBundleUtil.getBundleContext(), ServletContext.class);

    public static ServletContext getPathServletContext(String path) {
        ServletContext pathServletContext = null;
        for (ServletContext servletContext : _servletContexts) {
            String contextPath = servletContext.getContextPath();
            if (!Validator.isNotNull(contextPath) || !path.startsWith(contextPath)) continue;
            if (pathServletContext == null) {
                pathServletContext = servletContext;
                continue;
            }
            String pathServletContextContextPath = pathServletContext.getContextPath();
            if (contextPath.length() <= pathServletContextContextPath.length()) continue;
            pathServletContext = servletContext;
        }
        return pathServletContext;
    }

    public static URL getResource(ServletContext servletContext, String path) {
        block4: {
            if (servletContext == null) {
                return null;
            }
            path = PortalWebResourcesUtil.stripContextPath(servletContext, path);
            try {
                URL url = servletContext.getResource(path);
                if (url != null) {
                    return url;
                }
            }
            catch (MalformedURLException malformedURLException) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug(malformedURLException);
            }
        }
        return null;
    }

    public static URL getResource(String path) {
        ServletContext servletContext = DynamicResourceIncludeUtil.getPathServletContext(path);
        if (servletContext != null) {
            return DynamicResourceIncludeUtil.getResource(servletContext, path);
        }
        return null;
    }
}

