/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.PortalWebResourcesUtil;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;

public class FileAvailabilityUtil {
    private static final Log _log = LogFactoryUtil.getLog(FileAvailabilityUtil.class);

    public static void clearAvailabilities() {
        ServletContext servletContext = ServletContextPool.get(PortalUtil.getServletContextName());
        Map availabilities = (Map)servletContext.getAttribute(FileAvailabilityUtil.class.getName());
        if (availabilities != null) {
            servletContext.removeAttribute(FileAvailabilityUtil.class.getName());
        }
    }

    public static boolean isAvailable(ServletContext servletContext, String path) {
        URL url;
        Boolean available;
        Map<String, Boolean> availabilities;
        block5: {
            if (Validator.isNull(path)) {
                return false;
            }
            if (path.charAt(0) != '/') {
                return true;
            }
            availabilities = FileAvailabilityUtil._getAvailabilities(servletContext);
            available = availabilities.get(path);
            if (available != null) {
                return available;
            }
            url = null;
            try {
                url = servletContext.getResource(path);
            }
            catch (MalformedURLException malformedURLException) {
                if (!_log.isDebugEnabled()) break block5;
                _log.debug(malformedURLException);
            }
        }
        available = url == null && !PortalWebResourcesUtil.isAvailable(path) ? Boolean.FALSE : Boolean.TRUE;
        availabilities.put(path, available);
        return available;
    }

    private static Map<String, Boolean> _getAvailabilities(ServletContext servletContext) {
        ConcurrentHashMap availabilities = (ConcurrentHashMap)servletContext.getAttribute(FileAvailabilityUtil.class.getName());
        if (availabilities == null) {
            availabilities = new ConcurrentHashMap();
            servletContext.setAttribute(FileAvailabilityUtil.class.getName(), availabilities);
        }
        return availabilities;
    }
}

