/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.URLUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;

public class FileTimestampUtil {
    private static final Log _log = LogFactoryUtil.getLog(FileTimestampUtil.class);

    public static long getTimestamp(ServletContext servletContext, String path) {
        File uriFile;
        Long timestamp;
        if (Validator.isNull(path) || path.charAt(0) != '/') {
            return 0L;
        }
        String timestampsCacheKey = FileTimestampUtil.class.getName();
        ConcurrentHashMap<String, Long> timestamps = (ConcurrentHashMap<String, Long>)servletContext.getAttribute(timestampsCacheKey);
        if (timestamps == null) {
            timestamps = new ConcurrentHashMap<String, Long>();
            servletContext.setAttribute(timestampsCacheKey, timestamps);
        }
        if ((timestamp = (Long)timestamps.get(path)) != null) {
            return timestamp;
        }
        timestamp = 0L;
        String uriRealPath = servletContext.getRealPath(path);
        if (uriRealPath != null && (uriFile = new File(uriRealPath)).exists()) {
            timestamp = uriFile.lastModified();
            timestamps.put(path, timestamp);
            return timestamp;
        }
        try {
            URL url = servletContext.getResource(path);
            if (url == null) {
                _log.error("Resource URL for " + path + " is null");
            } else {
                timestamp = URLUtil.getLastModifiedTime(url);
            }
        }
        catch (IOException ioException) {
            _log.error(ioException);
        }
        timestamps.put(path, timestamp);
        return timestamp;
    }

    public static void reset(ServletContext servletContext) {
        String timestampsCacheKey = FileTimestampUtil.class.getName();
        servletContext.removeAttribute(timestampsCacheKey);
    }
}

