/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.template;

import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateManager;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class TemplateManagerUtil {
    private static final Log _log = LogFactoryUtil.getLog(TemplateManagerUtil.class);
    private static final BundleContext _bundleContext = SystemBundleUtil.getBundleContext();
    private static final ServiceTracker<TemplateManager, TemplateManager> _serviceTracker;
    private static final Map<String, Set<String>> _supportedLanguageTypes;
    private static final Map<String, TemplateManager> _templateManagers;

    public static void destroy() {
        for (TemplateManager templateManager : _templateManagers.values()) {
            templateManager.destroy();
        }
        _templateManagers.clear();
    }

    public static void destroy(ClassLoader classLoader) {
        for (TemplateManager templateManager : _templateManagers.values()) {
            templateManager.destroy(classLoader);
        }
    }

    public static Set<String> getSupportedLanguageTypes(String propertyKey) {
        Set<String> supportedLanguageTypes = _supportedLanguageTypes.get(propertyKey);
        if (supportedLanguageTypes != null) {
            return supportedLanguageTypes;
        }
        supportedLanguageTypes = new HashSet<String>();
        for (String templateManagerName : _templateManagers.keySet()) {
            String content = PropsUtil.get(propertyKey, new Filter(templateManagerName));
            if (!Validator.isNotNull(content)) continue;
            supportedLanguageTypes.add(templateManagerName);
        }
        supportedLanguageTypes = Collections.unmodifiableSet(supportedLanguageTypes);
        _supportedLanguageTypes.put(propertyKey, supportedLanguageTypes);
        return supportedLanguageTypes;
    }

    public static Template getTemplate(String templateManagerName, TemplateResource templateResource, boolean restricted) throws TemplateException {
        TemplateManager templateManager = TemplateManagerUtil._getTemplateManagerChecked(templateManagerName);
        return templateManager.getTemplate(templateResource, restricted);
    }

    public static TemplateManager getTemplateManager(String templateManagerName) {
        return _templateManagers.get(templateManagerName);
    }

    public static Set<String> getTemplateManagerNames() {
        return _templateManagers.keySet();
    }

    public static Map<String, TemplateManager> getTemplateManagers() {
        return Collections.unmodifiableMap(_templateManagers);
    }

    public static boolean hasTemplateManager(String templateManagerName) {
        return _templateManagers.containsKey(templateManagerName);
    }

    private static TemplateManager _getTemplateManagerChecked(String templateManagerName) throws TemplateException {
        TemplateManager templateManager = _templateManagers.get(templateManagerName);
        if (templateManager == null) {
            throw new TemplateException("Unsupported template manager " + templateManagerName);
        }
        return templateManager;
    }

    private TemplateManagerUtil() {
    }

    static {
        _supportedLanguageTypes = new ConcurrentHashMap<String, Set<String>>();
        _templateManagers = new ConcurrentHashMap<String, TemplateManager>();
        _serviceTracker = new ServiceTracker(_bundleContext, SystemBundleUtil.createFilter("(&(language.type=*)(objectClass=" + TemplateManager.class.getName() + "))"), (ServiceTrackerCustomizer)new TemplateManagerServiceTrackerCustomizer());
        _serviceTracker.open();
    }

    private static class TemplateManagerServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<TemplateManager, TemplateManager> {
        private TemplateManagerServiceTrackerCustomizer() {
        }

        public TemplateManager addingService(ServiceReference<TemplateManager> serviceReference) {
            TemplateManager templateManager;
            block2: {
                templateManager = (TemplateManager)_bundleContext.getService(serviceReference);
                try {
                    templateManager.init();
                    _templateManagers.put(templateManager.getName(), templateManager);
                }
                catch (TemplateException templateException) {
                    if (!_log.isWarnEnabled()) break block2;
                    String name = templateManager.getName();
                    _log.warn("Unable to init template manager " + name, templateException);
                }
            }
            return templateManager;
        }

        public void modifiedService(ServiceReference<TemplateManager> serviceReference, TemplateManager templateManager) {
            _templateManagers.compute(templateManager.getName(), (key, value) -> {
                block2: {
                    templateManager.destroy();
                    try {
                        templateManager.init();
                    }
                    catch (TemplateException templateException) {
                        if (!_log.isWarnEnabled()) break block2;
                        _log.warn("unable to init " + templateManager.getName() + " Template Manager ", templateException);
                    }
                }
                return templateManager;
            });
        }

        public void removedService(ServiceReference<TemplateManager> serviceReference, TemplateManager templateManager) {
            _bundleContext.ungetService(serviceReference);
            _templateManagers.remove(templateManager.getName());
            templateManager.destroy();
        }
    }
}

