/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.template;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.TemplateResourceLoader;
import java.util.Set;
import org.osgi.framework.BundleContext;

public class TemplateResourceLoaderUtil {
    private static final BundleContext _bundleContext = SystemBundleUtil.getBundleContext();
    private static final ServiceTrackerMap<String, TemplateResourceLoader> _templateResourceLoaders = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)_bundleContext, TemplateResourceLoader.class, null, (serviceReference, emitter) -> {
        TemplateResourceLoader templateResourceLoader = (TemplateResourceLoader)_bundleContext.getService(serviceReference);
        emitter.emit((Object)templateResourceLoader.getName());
        _bundleContext.ungetService(serviceReference);
    });
    private static final TemplateResourceLoaderUtil _templateResourceLoaderUtil = new TemplateResourceLoaderUtil();

    public static void clearCache() {
        for (TemplateResourceLoader templateResourceLoader : _templateResourceLoaders.values()) {
            templateResourceLoader.clearCache();
        }
    }

    public static void clearCache(String templateResourceLoaderName) throws TemplateException {
        TemplateResourceLoader templateResourceLoader = TemplateResourceLoaderUtil._getTemplateResourceLoader(templateResourceLoaderName);
        templateResourceLoader.clearCache();
    }

    public static void clearCache(String templateResourceLoaderName, String templateId) throws TemplateException {
        TemplateResourceLoader templateResourceLoader = TemplateResourceLoaderUtil._getTemplateResourceLoader(templateResourceLoaderName);
        templateResourceLoader.clearCache(templateId);
    }

    public static TemplateResource getTemplateResource(String templateResourceLoaderName, String templateId) throws TemplateException {
        TemplateResourceLoader templateResourceLoader = TemplateResourceLoaderUtil._getTemplateResourceLoader(templateResourceLoaderName);
        return templateResourceLoader.getTemplateResource(templateId);
    }

    public static TemplateResourceLoader getTemplateResourceLoader(String templateResourceLoaderName) throws TemplateException {
        return TemplateResourceLoaderUtil._getTemplateResourceLoader(templateResourceLoaderName);
    }

    public static Set<String> getTemplateResourceLoaderNames() {
        return _templateResourceLoaders.keySet();
    }

    public static boolean hasTemplateResource(String templateResourceLoaderName, String templateId) throws TemplateException {
        TemplateResourceLoader templateResourceLoader = TemplateResourceLoaderUtil._getTemplateResourceLoader(templateResourceLoaderName);
        return templateResourceLoader.hasTemplateResource(templateId);
    }

    public static boolean hasTemplateResourceLoader(String templateResourceLoaderName) {
        return _templateResourceLoaders.containsKey((Object)templateResourceLoaderName);
    }

    private static TemplateResourceLoader _getTemplateResourceLoader(String templateResourceLoaderName) throws TemplateException {
        TemplateResourceLoader templateResourceLoader = (TemplateResourceLoader)_templateResourceLoaders.getService((Object)templateResourceLoaderName);
        if (templateResourceLoader == null) {
            throw new TemplateException("Unsupported template resource loader " + templateResourceLoaderName);
        }
        return templateResourceLoader;
    }

    private TemplateResourceLoaderUtil() {
    }
}

