/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.theme;

import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.petra.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.servlet.PipingServletResponse;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateContextContributor;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResourceLoaderUtil;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.BundleContext;

public class ThemeUtil {
    private static final Log _log = LogFactoryUtil.getLog(ThemeUtil.class);
    private static final ServiceTrackerList<TemplateContextContributor> _templateContextContributors = ServiceTrackerListFactory.open((BundleContext)SystemBundleUtil.getBundleContext(), TemplateContextContributor.class, (String)"(type=THEME)");

    public static String getPortletId(HttpServletRequest httpServletRequest) {
        String portletId = null;
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (themeDisplay != null) {
            PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
            portletId = portletDisplay.getId();
        }
        return portletId;
    }

    public static void include(ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String path, Theme theme) throws Exception {
        ThemeUtil.include(servletContext, httpServletRequest, httpServletResponse, path, theme, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String include(ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String path, Theme theme, boolean write) throws Exception {
        String pluginServletContextName = GetterUtil.getString(theme.getServletContextName());
        ServletContext pluginServletContext = ServletContextPool.get(pluginServletContextName);
        ClassLoader pluginClassLoader = null;
        if (pluginServletContext != null) {
            pluginClassLoader = (ClassLoader)pluginServletContext.getAttribute("PLUGIN_CLASS_LOADER");
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        if (pluginClassLoader != null && pluginClassLoader != contextClassLoader) {
            currentThread.setContextClassLoader(pluginClassLoader);
        }
        try {
            String string = ThemeUtil.doIncludeFTL(servletContext, httpServletRequest, httpServletResponse, path, theme, false, write);
            return string;
        }
        finally {
            if (pluginClassLoader != null && pluginClassLoader != contextClassLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    protected static String doIncludeFTL(ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String path, Theme theme, boolean restricted, boolean write) throws Exception {
        String servletContextName = GetterUtil.getString(theme.getServletContextName());
        if (ServletContextPool.get(servletContextName) == null) {
            ServletContextPool.put(servletContextName, servletContext);
        }
        String portletId = ThemeUtil.getPortletId(httpServletRequest);
        String resourcePath = theme.getResourcePath(servletContext, portletId, path);
        if (Validator.isNotNull(portletId) && PortletIdCodec.hasInstanceId(portletId) && !TemplateResourceLoaderUtil.hasTemplateResource("ftl", resourcePath)) {
            String rootPortletId = PortletIdCodec.decodePortletName(portletId);
            resourcePath = theme.getResourcePath(servletContext, rootPortletId, path);
        }
        if (Validator.isNotNull(portletId) && !TemplateResourceLoaderUtil.hasTemplateResource("ftl", resourcePath)) {
            resourcePath = theme.getResourcePath(servletContext, null, path);
        }
        if (!TemplateResourceLoaderUtil.hasTemplateResource("ftl", resourcePath)) {
            _log.error(resourcePath + " does not exist");
            return null;
        }
        Template template = TemplateManagerUtil.getTemplate("ftl", TemplateResourceLoaderUtil.getTemplateResource("ftl", resourcePath), restricted);
        template.prepare(httpServletRequest);
        for (TemplateContextContributor templateContextContributor : _templateContextContributors) {
            templateContextContributor.prepare(template, httpServletRequest);
        }
        ServletContext themeServletContext = ServletContextPool.get(servletContextName);
        template.put("themeServletContext", themeServletContext);
        PrintWriter writer = null;
        if (write) {
            writer = httpServletResponse.getWriter();
        } else {
            writer = new UnsyncStringWriter();
            httpServletResponse = new PipingServletResponse((HttpServletResponse)httpServletResponse, (Writer)writer);
        }
        template.prepareTaglib(httpServletRequest, (HttpServletResponse)httpServletResponse);
        template.put("writer", writer);
        template.processTemplate(writer);
        if (write) {
            return null;
        }
        return writer.toString();
    }
}

