/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.upgrade;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseCompanyIdUpgradeProcess
extends UpgradeProcess {
    @Override
    protected void doUpgrade() throws Exception {
        DB db = DBManagerUtil.getDB();
        if (db.getDBType() == DBType.SQLSERVER) {
            for (TableUpdater tableUpdater2 : this.getTableUpdaters()) {
                this._addCompanyIdColumn(tableUpdater2);
            }
        } else {
            this.processConcurrently(this.getTableUpdaters(), tableUpdater -> this._addCompanyIdColumn((TableUpdater)tableUpdater), null);
        }
    }

    protected abstract TableUpdater[] getTableUpdaters();

    private void _addCompanyIdColumn(TableUpdater tableUpdater) throws Exception {
        String tableName = tableUpdater.getTableName();
        try (LoggingTimer loggingTimer = new LoggingTimer(tableName);){
            this.alterTableAddColumn(tableName, "companyId", "LONG");
            tableUpdater.update(this.connection);
        }
    }

    protected class TableUpdater {
        private final String _columnName;
        private boolean _createCompanyIdColumn;
        private final String[][] _foreignNamesArray;
        private final String _tableName;

        public TableUpdater(String tableName, String foreignTableName, String columnName) {
            this._tableName = tableName;
            this._columnName = columnName;
            this._foreignNamesArray = new String[][]{{foreignTableName, columnName}};
        }

        public TableUpdater(String tableName, String columnName, String[][] foreignNamesArray) {
            this._tableName = tableName;
            this._columnName = columnName;
            this._foreignNamesArray = foreignNamesArray;
        }

        public String getTableName() {
            return this._tableName;
        }

        public void setCreateCompanyIdColumn(boolean createCompanyIdColumn) {
            this._createCompanyIdColumn = createCompanyIdColumn;
        }

        public void update(Connection connection) throws Exception {
            for (String[] foreignNames : this._foreignNamesArray) {
                BaseCompanyIdUpgradeProcess.this.runSQL(connection, this.getUpdateSQL(connection, foreignNames[0], foreignNames[1]));
            }
        }

        protected List<Long> getCompanyIds(Connection connection) throws SQLException {
            ArrayList<Long> companyIds = new ArrayList<Long>();
            try (PreparedStatement preparedStatement = connection.prepareStatement("select companyId from Company");
                 ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    long companyId = resultSet.getLong(1);
                    companyIds.add(companyId);
                }
            }
            return companyIds;
        }

        protected String getSelectSQL(Connection connection, String foreignTableName, String foreignColumnName) throws SQLException {
            List<Long> companyIds = this.getCompanyIds(connection);
            if (companyIds.size() == 1) {
                return String.valueOf(companyIds.get(0));
            }
            return StringBundler.concat((String[])new String[]{"select max(companyId) from ", foreignTableName, " where ", foreignTableName, ".", foreignColumnName, " > 0 and ", foreignTableName, ".", foreignColumnName, " = ", this._tableName, ".", this._columnName});
        }

        protected String getUpdateSQL(Connection connection, String foreignTableName, String foreignColumnName) throws SQLException {
            return this.getUpdateSQL(this.getSelectSQL(connection, foreignTableName, foreignColumnName));
        }

        protected String getUpdateSQL(String selectSQL) {
            return StringBundler.concat((String[])new String[]{"update ", this._tableName, " set companyId = (", selectSQL, ")"});
        }
    }
}

