/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.upgrade;

import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.model.PortletPreferenceValue;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.simple.Element;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.portlet.PortletPreferences;
import javax.portlet.ReadOnlyException;

public abstract class BasePortletPreferencesUpgradeProcess
extends UpgradeProcess {
    @Override
    protected void doUpgrade() throws Exception {
        this.updatePortletPreferences();
    }

    protected long getCompanyId(String sql, long primaryKey) throws Exception {
        long companyId = 0L;
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(sql);){
            preparedStatement.setLong(1, primaryKey);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    companyId = resultSet.getLong("companyId");
                }
            }
        }
        return companyId;
    }

    protected Object[] getGroup(long groupId) throws Exception {
        Object[] group = null;
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select companyId from Group_ where groupId = ?");){
            preparedStatement.setLong(1, groupId);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    long companyId = resultSet.getLong("companyId");
                    group = new Object[]{groupId, companyId};
                }
            }
        }
        return group;
    }

    protected Object[] getLayout(long plid) throws Exception {
        Object[] layout = null;
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select groupId, companyId, privateLayout, layoutId from Layout where plid = ?");){
            preparedStatement.setLong(1, plid);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    long groupId = resultSet.getLong("groupId");
                    long companyId = resultSet.getLong("companyId");
                    boolean privateLayout = resultSet.getBoolean("privateLayout");
                    long layoutId = resultSet.getLong("layoutId");
                    layout = new Object[]{groupId, companyId, privateLayout, layoutId};
                }
            }
        }
        if (layout == null) {
            layout = this.getLayoutRevision(plid);
        }
        return layout;
    }

    protected Object[] getLayoutRevision(long layoutRevisionId) throws Exception {
        Object[] layoutRevision = null;
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select groupId, companyId, privateLayout, layoutRevisionId from LayoutRevision where layoutRevisionId = ?");){
            preparedStatement.setLong(1, layoutRevisionId);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    long groupId = resultSet.getLong("groupId");
                    long companyId = resultSet.getLong("companyId");
                    boolean privateLayout = resultSet.getBoolean("privateLayout");
                    long layoutId = resultSet.getLong("layoutRevisionId");
                    layoutRevision = new Object[]{groupId, companyId, privateLayout, layoutId};
                }
            }
        }
        return layoutRevision;
    }

    protected String getLayoutUuid(long plid, long layoutId) throws Exception {
        Object[] layout = this.getLayout(plid);
        if (layout == null) {
            return null;
        }
        String uuid = null;
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select uuid_ from Layout where groupId = ? and privateLayout = ? and layoutId = ?");){
            long groupId = (Long)layout[0];
            boolean privateLayout = (Boolean)layout[2];
            preparedStatement.setLong(1, groupId);
            preparedStatement.setBoolean(2, privateLayout);
            preparedStatement.setLong(3, layoutId);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    uuid = resultSet.getString("uuid_");
                }
            }
        }
        return uuid;
    }

    protected String[] getPortletIds() {
        return new String[0];
    }

    protected String getUpdatePortletPreferencesWhereClause() {
        String[] portletIds = this.getPortletIds();
        if (portletIds.length == 0) {
            throw new IllegalArgumentException("Subclasses must override getPortletIds or getUpdatePortletPreferencesWhereClause");
        }
        StringBundler sb = new StringBundler(portletIds.length * 5 - 1);
        for (int i = 0; i < portletIds.length; ++i) {
            String portletId = portletIds[i];
            sb.append("PortletPreferences.portletId ");
            if (portletId.contains("%")) {
                sb.append(" like '");
                sb.append(portletId);
                sb.append("'");
            } else {
                sb.append(" = '");
                sb.append(portletId);
                sb.append("'");
            }
            if (i + 1 >= portletIds.length) continue;
            sb.append(" or ");
        }
        return sb.toString();
    }

    protected void updatePortletPreferences() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            if (this.hasColumn("PortletPreferences", "preferences")) {
                this._updatePortletPreferences();
            } else {
                this._updatePortletPreferenceValues();
            }
        }
    }

    protected void upgradeMultiValuePreference(PortletPreferences portletPreferences, String key) throws ReadOnlyException {
        String value = portletPreferences.getValue(key, "");
        if (Validator.isNotNull(value)) {
            portletPreferences.setValues(key, StringUtil.split(value));
        }
    }

    protected abstract String upgradePreferences(long var1, long var3, int var5, long var6, String var8, String var9) throws Exception;

    private Map<String, PreferenceValues> _getPreferenceValuesMap(PreparedStatement selectPreparedStatement) throws Exception {
        HashMap<String, PreferenceValues> preferenceValuesMap = new HashMap<String, PreferenceValues>();
        try (ResultSet resultSet = selectPreparedStatement.executeQuery();){
            while (resultSet.next()) {
                long portletPreferenceValueId = resultSet.getLong("portletPreferenceValueId");
                String name = resultSet.getString("name");
                String value = resultSet.getString("smallValue");
                if (Validator.isBlank(value)) {
                    value = resultSet.getString("largeValue");
                }
                boolean readOnly = resultSet.getBoolean("readOnly");
                PreferenceValues preferenceValues = preferenceValuesMap.computeIfAbsent(name, key -> new PreferenceValues());
                preferenceValues._portletPreferenceValueIds.add(portletPreferenceValueId);
                PreferenceValues preferenceValues2 = preferenceValues;
                preferenceValues2._readOnly = preferenceValues2._readOnly | readOnly;
                preferenceValues._values.add(value);
            }
        }
        return preferenceValuesMap;
    }

    private String _toXMLString(Map<String, PreferenceValues> preferenceMap) {
        if (preferenceMap.isEmpty()) {
            return "<portlet-preferences />";
        }
        Element portletPreferencesElement = new Element("portlet-preferences", false);
        for (Map.Entry<String, PreferenceValues> entry : preferenceMap.entrySet()) {
            Element preferenceElement = portletPreferencesElement.addElement("preference");
            preferenceElement.addElement("name", entry.getKey());
            PreferenceValues preferenceValues = entry.getValue();
            for (String value : preferenceValues._values) {
                preferenceElement.addElement("value", value);
            }
            if (!preferenceValues._readOnly) continue;
            preferenceElement.addElement("read-only", Boolean.TRUE);
        }
        return portletPreferencesElement.toXMLString();
    }

    private void _updatePortletPreferences() throws Exception {
        StringBundler sb = new StringBundler(5);
        sb.append("select portletPreferencesId, companyId, ownerId, ");
        sb.append("ownerType, plid, portletId, preferences from ");
        sb.append("PortletPreferences");
        String whereClause = this.getUpdatePortletPreferencesWhereClause();
        if (Validator.isNotNull(whereClause)) {
            sb.append(" where ");
            sb.append(whereClause);
        }
        this.processConcurrently(sb.toString(), (UnsafeFunction<ResultSet, Object[], Exception>)((UnsafeFunction)resultSet -> {
            long portletPreferencesId = resultSet.getLong("portletPreferencesId");
            long companyId = resultSet.getLong("companyId");
            int ownerType = resultSet.getInt("ownerType");
            long plid = resultSet.getLong("plid");
            long ownerId = resultSet.getLong("ownerId");
            String portletId = resultSet.getString("portletId");
            String preferences = resultSet.getString("preferences");
            return new Object[]{portletPreferencesId, companyId, ownerType, plid, ownerId, portletId, preferences};
        }), (UnsafeConsumer<Object[], Exception>)((UnsafeConsumer)values -> this._updatePortletPreferences((Object[])values)), "Unable to update PortletPreferences");
    }

    private void _updatePortletPreferences(Object[] values) throws Exception {
        long portletPreferencesId = (Long)values[0];
        long companyId = (Long)values[1];
        if (companyId <= 0L) {
            this.runSQL("delete from PortletPreferences where portletPreferencesId = " + portletPreferencesId);
            return;
        }
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("update PortletPreferences set preferences = ? where portletPreferencesId = ?");){
            int ownerType = (Integer)values[2];
            long plid = (Long)values[3];
            long ownerId = (Long)values[4];
            String portletId = (String)values[5];
            String preferences = (String)values[6];
            String newPreferences = this.upgradePreferences(companyId, ownerId, ownerType, plid, portletId, preferences);
            if (!preferences.equals(newPreferences)) {
                preparedStatement.setString(1, newPreferences);
                preparedStatement.setLong(2, portletPreferencesId);
                preparedStatement.executeUpdate();
            }
        }
    }

    private void _updatePortletPreferenceValues() throws Exception {
        StringBundler sb = new StringBundler(5);
        sb.append("select ctCollectionId, portletPreferencesId, companyId, ");
        sb.append("ownerId, ownerType, plid, portletId from ");
        sb.append("PortletPreferences");
        String whereClause = this.getUpdatePortletPreferencesWhereClause();
        if (Validator.isNotNull(whereClause)) {
            sb.append(" where ");
            sb.append(whereClause);
        }
        this.processConcurrently(sb.toString(), (UnsafeFunction<ResultSet, Object[], Exception>)((UnsafeFunction)resultSet -> {
            long portletPreferencesId = resultSet.getLong("portletPreferencesId");
            long companyId = resultSet.getLong("companyId");
            int ownerType = resultSet.getInt("ownerType");
            long plid = resultSet.getLong("plid");
            long ownerId = resultSet.getLong("ownerId");
            String portletId = resultSet.getString("portletId");
            long ctCollectionId = resultSet.getLong("ctCollectionId");
            return new Object[]{portletPreferencesId, companyId, ownerType, plid, ownerId, portletId, ctCollectionId};
        }), (UnsafeConsumer<Object[], Exception>)((UnsafeConsumer)values -> this._updatePortletPreferenceValues((Object[])values)), "Unable to update PortletPreferences and PortletPreferenceValue");
    }

    private void _updatePortletPreferenceValues(Object[] values) throws Exception {
        long portletPreferencesId = (Long)values[0];
        long companyId = (Long)values[1];
        if (companyId <= 0L) {
            this.runSQL("delete from PortletPreferences where portletPreferencesId = " + portletPreferencesId);
            this.runSQL("delete from PortletPreferenceValue where portletPreferencesId = " + portletPreferencesId);
            return;
        }
        int ownerType = (Integer)values[2];
        long plid = (Long)values[3];
        long ownerId = (Long)values[4];
        String portletId = (String)values[5];
        long ctCollectionId = (Long)values[6];
        try (PreparedStatement preparedStatement1 = AutoBatchPreparedStatementUtil.autoBatch(this.connection, StringBundler.concat((String[])new String[]{"select portletPreferenceValueId, largeValue, name, ", "readOnly, smallValue from PortletPreferenceValue ", "where portletPreferencesId = ? order by index_ asc"}));
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch(this.connection, StringBundler.concat((String[])new String[]{"insert into PortletPreferenceValue (mvccVersion, ", "ctCollectionId, portletPreferenceValueId, companyId, ", "portletPreferencesId, index_, largeValue, name, ", "readOnly, smallValue) values (0, ?, ?, ?, ?, ?, ?, ", "?, ?, ?)"}));
             PreparedStatement preparedStatement3 = AutoBatchPreparedStatementUtil.concurrentAutoBatch(this.connection, StringBundler.concat((String[])new String[]{"update PortletPreferenceValue set largeValue = ?, ", "readOnly = ?, smallValue = ? where ", "portletPreferenceValueId = ?"}));
             PreparedStatement preparedStatement4 = AutoBatchPreparedStatementUtil.concurrentAutoBatch(this.connection, "delete from PortletPreferenceValue where portletPreferenceValueId = ?");){
            preparedStatement1.setLong(1, portletPreferencesId);
            Map<String, PreferenceValues> preferenceValuesMap = this._getPreferenceValuesMap(preparedStatement1);
            String preferences = this._toXMLString(preferenceValuesMap);
            String newPreferences = this.upgradePreferences(companyId, ownerId, ownerType, plid, portletId, preferences);
            if (preferences.equals(newPreferences)) {
                return;
            }
            this._upgradePortletPreferenceValues(preferenceValuesMap, ctCollectionId, portletPreferencesId, companyId, newPreferences, preparedStatement2, preparedStatement3, preparedStatement4);
            preparedStatement2.executeBatch();
            preparedStatement3.executeBatch();
            preparedStatement4.executeBatch();
        }
    }

    private void _upgradePortletPreferenceValues(Map<String, PreferenceValues> preferenceMap, long ctCollectionId, long portletPreferencesId, long companyId, String newPreferences, PreparedStatement insertPreparedStatement, PreparedStatement updatePreparedStatement, PreparedStatement deletePreparedStatement) throws Exception {
        Object values;
        PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.fromDefaultXML(newPreferences);
        HashMap<String, AbstractMap.SimpleImmutableEntry<PreferenceValues, PreferenceValues>> preferenceEntries = new HashMap<String, AbstractMap.SimpleImmutableEntry<PreferenceValues, PreferenceValues>>(preferenceMap.size());
        int newCount = 0;
        Map newPreferenceMap = portletPreferences.getMap();
        for (Map.Entry entry : newPreferenceMap.entrySet()) {
            values = (String[])entry.getValue();
            if (values == null) continue;
            int size = 0;
            String name = (String)entry.getKey();
            PreferenceValues preferenceValues = preferenceMap.remove(name);
            if (preferenceValues != null) {
                size = preferenceValues._values.size();
            }
            if (((Object)values).length > size) {
                newCount += ((Object)values).length - size;
            }
            PreferenceValues newPreferenceValues = new PreferenceValues();
            newPreferenceValues._readOnly = portletPreferences.isReadOnly((String)entry.getKey());
            Collections.addAll(newPreferenceValues._values, values);
            preferenceEntries.put(name, new AbstractMap.SimpleImmutableEntry<PreferenceValues, PreferenceValues>(preferenceValues, newPreferenceValues));
        }
        for (PreferenceValues portletPreferenceValues : preferenceMap.values()) {
            values = portletPreferenceValues._portletPreferenceValueIds.iterator();
            while (values.hasNext()) {
                long portletPreferenceValueId = (Long)values.next();
                deletePreparedStatement.setLong(1, portletPreferenceValueId);
                deletePreparedStatement.addBatch();
            }
        }
        long batchCounter = 0L;
        if (newCount > 0) {
            batchCounter = this.increment(PortletPreferenceValue.class.getName(), newCount);
            batchCounter -= (long)newCount;
        }
        int smallValueMaxLength = ModelHintsUtil.getMaxLength(PortletPreferenceValue.class.getName(), "smallValue");
        for (Map.Entry entry : preferenceEntries.entrySet()) {
            int i;
            Map.Entry preferenceValuesEntry = (Map.Entry)entry.getValue();
            PreferenceValues oldPreferenceValues = (PreferenceValues)preferenceValuesEntry.getKey();
            PreferenceValues newPreferenceValues = (PreferenceValues)preferenceValuesEntry.getValue();
            List newValues = newPreferenceValues._values;
            int oldSize = 0;
            if (oldPreferenceValues != null) {
                oldSize = oldPreferenceValues._values.size();
            }
            for (i = 0; i < newValues.size(); ++i) {
                String smallValue;
                String largeValue;
                String value = (String)newValues.get(i);
                if (oldSize > i) {
                    if (Objects.equals(value, oldPreferenceValues._values.get(i)) && newPreferenceValues._readOnly == oldPreferenceValues._readOnly) continue;
                    largeValue = null;
                    smallValue = null;
                    if (value.length() > smallValueMaxLength) {
                        largeValue = value;
                    } else {
                        smallValue = value;
                    }
                    updatePreparedStatement.setString(1, largeValue);
                    updatePreparedStatement.setBoolean(2, newPreferenceValues._readOnly);
                    updatePreparedStatement.setString(3, smallValue);
                    updatePreparedStatement.setLong(4, (Long)oldPreferenceValues._portletPreferenceValueIds.get(i));
                    updatePreparedStatement.addBatch();
                    continue;
                }
                largeValue = null;
                smallValue = null;
                if (value.length() > smallValueMaxLength) {
                    largeValue = value;
                } else {
                    smallValue = value;
                }
                insertPreparedStatement.setLong(1, ctCollectionId);
                insertPreparedStatement.setLong(2, ++batchCounter);
                insertPreparedStatement.setLong(3, companyId);
                insertPreparedStatement.setLong(4, portletPreferencesId);
                insertPreparedStatement.setInt(5, i);
                insertPreparedStatement.setString(6, largeValue);
                insertPreparedStatement.setString(7, (String)entry.getKey());
                insertPreparedStatement.setBoolean(8, newPreferenceValues._readOnly);
                insertPreparedStatement.setString(9, smallValue);
                insertPreparedStatement.addBatch();
            }
            for (i = newValues.size(); i < oldSize; ++i) {
                deletePreparedStatement.setLong(1, (Long)oldPreferenceValues._portletPreferenceValueIds.get(i));
                deletePreparedStatement.addBatch();
            }
        }
    }

    private static class PreferenceValues {
        private final List<Long> _portletPreferenceValueIds = new ArrayList<Long>();
        private boolean _readOnly;
        private final List<String> _values = new ArrayList<String>();

        private PreferenceValues() {
        }
    }
}

