/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.upgrade;

import com.liferay.portal.kernel.dao.db.DBInspector;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Element;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;

public class MVCCVersionUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(MVCCVersionUpgradeProcess.class);

    public void upgradeMVCCVersion(DatabaseMetaData databaseMetaData, String tableName) throws Exception {
        for (String excludeTableName : this.getExcludedTableNames()) {
            if (!StringUtil.equalsIgnoreCase(excludeTableName, tableName)) continue;
            return;
        }
        DBInspector dbInspector = new DBInspector(this.connection);
        tableName = dbInspector.normalizeName(tableName, databaseMetaData);
        this.ensureTableExists(databaseMetaData, dbInspector, tableName);
        try (ResultSet columnResultSet = databaseMetaData.getColumns(dbInspector.getCatalog(), dbInspector.getSchema(), tableName, dbInspector.normalizeName("mvccVersion", databaseMetaData));){
            if (columnResultSet.next()) {
                return;
            }
            this.alterTableAddColumn(tableName, "mvccVersion", "LONG default 0 not null");
            if (_log.isDebugEnabled()) {
                _log.debug("Added column mvccVersion to table " + tableName);
            }
        }
    }

    @Override
    protected void doUpgrade() throws Exception {
        this.upgradeModuleTableMVCCVersions();
    }

    protected String[] getExcludedTableNames() {
        return new String[0];
    }

    protected String[] getModuleTableNames() {
        return new String[]{"BackgroundTask", "Lock_"};
    }

    protected void upgradeModuleTableMVCCVersions() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            String[] moduleTableNames;
            DatabaseMetaData databaseMetaData = this.connection.getMetaData();
            for (String moduleTableName : moduleTableNames = this.getModuleTableNames()) {
                this.upgradeMVCCVersion(databaseMetaData, moduleTableName);
            }
        }
    }

    protected void upgradeMVCCVersion(DatabaseMetaData databaseMetaData, Element classElement) throws Exception {
        String tableName = classElement.attributeValue("table");
        this.upgradeMVCCVersion(databaseMetaData, tableName);
    }
}

