/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.upgrade.util;

import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.kernel.version.Version;
import java.util.ArrayList;
import java.util.Collections;
import java.util.TreeMap;

public class UpgradeVersionTreeMap
extends TreeMap<Version, UpgradeProcess> {
    @Override
    public UpgradeProcess put(Version key, UpgradeProcess upgradeProcess) {
        this._put(key, upgradeProcess.getUpgradeSteps());
        return upgradeProcess;
    }

    @Override
    public void put(Version key, UpgradeProcess ... upgradeProcesses) {
        ArrayList upgradeStepList = new ArrayList();
        for (UpgradeProcess upgradeProcess : upgradeProcesses) {
            Collections.addAll(upgradeStepList, upgradeProcess.getUpgradeSteps());
        }
        this._put(key, upgradeStepList.toArray(new UpgradeStep[0]));
    }

    private void _put(Version key, UpgradeStep ... upgradeProcesses) {
        for (int i = 0; i < upgradeProcesses.length - 1; ++i) {
            UpgradeStep upgradeStep = upgradeProcesses[i];
            Version stepVersion = new Version(key.getMajor(), key.getMinor(), key.getMicro(), "step-" + (i + 1));
            super.put(stepVersion, (UpgradeProcess)upgradeStep);
        }
        Version finalVersion = new Version(key.getMajor(), key.getMinor(), key.getMicro());
        super.put(finalVersion, (UpgradeProcess)upgradeProcesses[upgradeProcesses.length - 1]);
    }
}

