/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.concurrent.DefaultNoticeableFuture;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public class InetAddressUtil {
    private static final int _DNS_SECURITY_ADDRESS_TIMEOUT_SECONDS = GetterUtil.getInteger(PropsUtil.get("dns.security.address.timeout.seconds"));
    private static final int _DNS_SECURITY_THREAD_LIMIT = GetterUtil.getInteger(PropsUtil.get("dns.security.thread.limit"));
    private static final Log _log = LogFactoryUtil.getLog(InetAddressUtil.class);

    public static InetAddress getInetAddressByName(String domain) throws UnknownHostException {
        AtomicInteger atomicInteger = new AtomicInteger(_DNS_SECURITY_THREAD_LIMIT);
        try {
            if (atomicInteger.getAndDecrement() <= 0) {
                _log.error("Thread limit exceeded to resolve domain: " + domain);
                InetAddress inetAddress = null;
                return inetAddress;
            }
            DefaultNoticeableFuture<InetAddress> defaultNoticeableFuture = new DefaultNoticeableFuture<InetAddress>(() -> InetAddress.getByName(domain));
            Thread thread = new Thread(defaultNoticeableFuture, "Inet Address Util");
            thread.setDaemon(true);
            thread.start();
            InetAddress inetAddress = (InetAddress)defaultNoticeableFuture.get(_DNS_SECURITY_ADDRESS_TIMEOUT_SECONDS, TimeUnit.SECONDS);
            return inetAddress;
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            if (_log.isDebugEnabled()) {
                _log.debug(exception);
            }
            throw new UnknownHostException("Unable to resolve domain: " + domain);
        }
        finally {
            atomicInteger.incrementAndGet();
        }
    }

    public static String getLocalHostName() throws Exception {
        return LocalHostNameHolder._LOCAL_HOST_NAME;
    }

    public static InetAddress getLocalInetAddress() throws Exception {
        Enumeration<NetworkInterface> enumeration1 = NetworkInterface.getNetworkInterfaces();
        while (enumeration1.hasMoreElements()) {
            NetworkInterface networkInterface = enumeration1.nextElement();
            Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
            while (enumeration2.hasMoreElements()) {
                InetAddress inetAddress = enumeration2.nextElement();
                if (inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address)) continue;
                return inetAddress;
            }
        }
        throw new SystemException("No local internet address");
    }

    public static InetAddress getLoopbackInetAddress() throws UnknownHostException {
        return InetAddress.getByName("127.0.0.1");
    }

    public static boolean isLocalInetAddress(InetAddress inetAddress) {
        return inetAddress.isAnyLocalAddress() || inetAddress.isLinkLocalAddress() || inetAddress.isLoopbackAddress() || inetAddress.isSiteLocalAddress();
    }

    private static class LocalHostNameHolder {
        private static final String _LOCAL_HOST_NAME;

        private LocalHostNameHolder() {
        }

        static {
            try {
                InetAddress inetAddress = InetAddressUtil.getLocalInetAddress();
                _LOCAL_HOST_NAME = inetAddress.getHostName();
            }
            catch (Exception exception) {
                throw new ExceptionInInitializerError(exception);
            }
        }
    }
}

