/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.workflow.messaging;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.DestinationEventListener;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.messaging.MessageListener;

public class DefaultWorkflowDestinationEventListener
implements DestinationEventListener {
    private static final Log _log = LogFactoryUtil.getLog(DefaultWorkflowDestinationEventListener.class);
    private MessageListener _workflowComparatorFactoryListener;
    private MessageListener _workflowDefinitionManagerListener;
    private MessageListener _workflowEngineManagerListener;
    private String _workflowEngineName;
    private MessageListener _workflowInstanceManagerListener;
    private MessageListener _workflowLogManagerListener;
    private MessageListener _workflowStatusManagerListener;
    private MessageListener _workflowTaskManagerListener;

    @Override
    public void messageListenerRegistered(String destinationName, MessageListener messageListener) {
        if (_log.isInfoEnabled()) {
            _log.info("Unregistering default workflow engine " + this._workflowEngineName);
        }
        if (!this.isProceed(destinationName, messageListener)) {
            return;
        }
        MessageBusUtil.unregisterMessageListener("liferay/workflow_comparator", this._workflowComparatorFactoryListener);
        MessageBusUtil.unregisterMessageListener("liferay/workflow_definition", this._workflowDefinitionManagerListener);
        MessageBusUtil.unregisterMessageListener("liferay/workflow_engine", this._workflowEngineManagerListener);
        MessageBusUtil.unregisterMessageListener("liferay/workflow_instance", this._workflowInstanceManagerListener);
        MessageBusUtil.unregisterMessageListener("liferay/workflow_log", this._workflowLogManagerListener);
        MessageBusUtil.unregisterMessageListener("liferay/workflow_status", this._workflowStatusManagerListener);
        MessageBusUtil.unregisterMessageListener("liferay/workflow_task", this._workflowTaskManagerListener);
    }

    @Override
    public void messageListenerUnregistered(String destinationName, MessageListener messageListener) {
        if (!this.isProceed(destinationName, messageListener)) {
            return;
        }
        if (_log.isInfoEnabled()) {
            _log.info("Registering default workflow engine " + this._workflowEngineName);
        }
        MessageBusUtil.registerMessageListener("liferay/workflow_comparator", this._workflowComparatorFactoryListener);
        MessageBusUtil.registerMessageListener("liferay/workflow_definition", this._workflowDefinitionManagerListener);
        MessageBusUtil.registerMessageListener("liferay/workflow_engine", this._workflowEngineManagerListener);
        MessageBusUtil.registerMessageListener("liferay/workflow_instance", this._workflowInstanceManagerListener);
        MessageBusUtil.registerMessageListener("liferay/workflow_log", this._workflowLogManagerListener);
        MessageBusUtil.registerMessageListener("liferay/workflow_status", this._workflowStatusManagerListener);
        MessageBusUtil.registerMessageListener("liferay/workflow_task", this._workflowTaskManagerListener);
    }

    public void setWorkflowComparatorFactoryListener(MessageListener workflowComparatorFactoryListener) {
        this._workflowComparatorFactoryListener = workflowComparatorFactoryListener;
    }

    public void setWorkflowDefinitionManagerListener(MessageListener workflowDefinitionManagerListener) {
        this._workflowDefinitionManagerListener = workflowDefinitionManagerListener;
    }

    public void setWorkflowEngineManagerListener(MessageListener workflowEngineManagerListener) {
        this._workflowEngineManagerListener = workflowEngineManagerListener;
    }

    public void setWorkflowEngineName(String workflowEngineName) {
        this._workflowEngineName = workflowEngineName;
    }

    public void setWorkflowInstanceManagerListener(MessageListener workflowInstanceManagerListener) {
        this._workflowInstanceManagerListener = workflowInstanceManagerListener;
    }

    public void setWorkflowLogManagerListener(MessageListener workflowLogManagerListener) {
        this._workflowLogManagerListener = workflowLogManagerListener;
    }

    public void setWorkflowStatusManagerListener(MessageListener workflowStatusManagerListener) {
        this._workflowStatusManagerListener = workflowStatusManagerListener;
    }

    public void setWorkflowTaskManagerListener(MessageListener workflowTaskManagerListener) {
        this._workflowTaskManagerListener = workflowTaskManagerListener;
    }

    protected boolean isProceed(String destinationName, MessageListener messageListener) {
        return !messageListener.equals(this._workflowEngineManagerListener);
    }
}

