/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.kernel.util.comparator;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileShortcut;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLFileEntryLocalServiceUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.OrderByComparator;

public class RepositoryModelSizeComparator<T>
extends OrderByComparator<T> {
    public static final String ORDER_BY_ASC = "size_ ASC";
    public static final String ORDER_BY_DESC = "size_ DESC";
    public static final String[] ORDER_BY_FIELDS = new String[]{"size"};
    public static final String ORDER_BY_MODEL_ASC = "modelFolder DESC, size_ ASC";
    public static final String ORDER_BY_MODEL_DESC = "modelFolder DESC, size_ DESC";
    private final boolean _ascending;
    private final boolean _orderByModel;

    public RepositoryModelSizeComparator() {
        this(false);
    }

    public RepositoryModelSizeComparator(boolean ascending) {
        this._ascending = ascending;
        this._orderByModel = false;
    }

    public RepositoryModelSizeComparator(boolean ascending, boolean orderByModel) {
        this._ascending = ascending;
        this._orderByModel = orderByModel;
    }

    @Override
    public int compare(T t1, T t2) {
        int value = 0;
        Long size1 = this.getSize(t1);
        Long size2 = this.getSize(t2);
        value = this._orderByModel ? ((t1 instanceof DLFolder || t1 instanceof Folder) && (t2 instanceof DLFolder || t2 instanceof Folder) ? size1.compareTo(size2) : (t1 instanceof DLFolder || t1 instanceof Folder ? -1 : (t2 instanceof DLFolder || t2 instanceof Folder ? 1 : size1.compareTo(size2)))) : size1.compareTo(size2);
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    @Override
    public String getOrderBy() {
        if (this._orderByModel) {
            if (this._ascending) {
                return ORDER_BY_MODEL_ASC;
            }
            return ORDER_BY_MODEL_DESC;
        }
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    @Override
    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    @Override
    public boolean isAscending() {
        return this._ascending;
    }

    protected long getFileShortcutSize(Object object) {
        long toFileEntryId = 0L;
        if (object instanceof FileShortcut) {
            FileShortcut fileShortcut = (FileShortcut)object;
            toFileEntryId = fileShortcut.getToFileEntryId();
        } else {
            DLFileShortcut dlFileShortcut = (DLFileShortcut)object;
            toFileEntryId = dlFileShortcut.getToFileEntryId();
        }
        try {
            DLFileEntry dlFileEntry = DLFileEntryLocalServiceUtil.getFileEntry(toFileEntryId);
            return dlFileEntry.getSize();
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    protected long getSize(Object object) {
        if (object instanceof DLFileEntry) {
            DLFileEntry dlFileEntry = (DLFileEntry)object;
            return dlFileEntry.getSize();
        }
        if (object instanceof DLFileShortcut || object instanceof FileShortcut) {
            return this.getFileShortcutSize(object);
        }
        if (object instanceof DLFolder || object instanceof Folder) {
            return 0L;
        }
        FileEntry fileEntry = (FileEntry)object;
        return fileEntry.getSize();
    }
}

