/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.backgroundtask;

import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskResult;
import com.liferay.portal.kernel.backgroundtask.DelegatingBackgroundTaskExecutor;

public class ClassLoaderAwareBackgroundTaskExecutor
extends DelegatingBackgroundTaskExecutor {
    private final ClassLoader _classLoader;

    public ClassLoaderAwareBackgroundTaskExecutor(BackgroundTaskExecutor backgroundTaskExecutor, ClassLoader classLoader) {
        super(backgroundTaskExecutor);
        this._classLoader = classLoader;
    }

    @Override
    public BackgroundTaskExecutor clone() {
        return new ClassLoaderAwareBackgroundTaskExecutor(this.getBackgroundTaskExecutor(), this._classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BackgroundTaskResult execute(BackgroundTask backgroundTask) throws Exception {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        if (this._classLoader != contextClassLoader) {
            currentThread.setContextClassLoader(this._classLoader);
        }
        try {
            BackgroundTaskExecutor backgroundTaskExecutor = this.getBackgroundTaskExecutor();
            BackgroundTaskResult backgroundTaskResult = backgroundTaskExecutor.execute(backgroundTask);
            return backgroundTaskResult;
        }
        finally {
            if (this._classLoader != contextClassLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }
}

