/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.deploy.auto;

import com.liferay.portal.kernel.deploy.auto.AutoDeployException;
import com.liferay.portal.kernel.deploy.auto.AutoDeployListener;
import com.liferay.portal.kernel.deploy.auto.AutoDeployer;
import com.liferay.portal.kernel.deploy.auto.context.AutoDeploymentContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.File;
import java.io.IOException;

public abstract class BaseAutoDeployListener
implements AutoDeployListener {
    private static final Log _log = LogFactoryUtil.getLog(BaseAutoDeployListener.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final int deploy(AutoDeploymentContext autoDeploymentContext) throws AutoDeployException {
        File file = autoDeploymentContext.getFile();
        if (_log.isDebugEnabled()) {
            _log.debug("Invoking deploy for " + file.getPath());
        }
        if (_log.isInfoEnabled()) {
            _log.info(this.getPluginPathInfoMessage(file));
        }
        try (AutoDeployer autoDeployer = this.buildAutoDeployer();){
            int code = autoDeployer.autoDeploy(autoDeploymentContext);
            if (code == 1 && _log.isInfoEnabled()) {
                _log.info(this.getSuccessMessage(file));
            }
            int n = code;
            return n;
        }
        catch (IOException ioException) {
            throw new AutoDeployException(ioException);
        }
    }

    @Override
    public boolean isDeployable(AutoDeploymentContext autoDeploymentContext) throws AutoDeployException {
        return this.isDeployable(autoDeploymentContext.getFile());
    }

    protected abstract AutoDeployer buildAutoDeployer() throws AutoDeployException;

    protected abstract String getPluginPathInfoMessage(File var1);

    protected abstract String getSuccessMessage(File var1);

    protected abstract boolean isDeployable(File var1) throws AutoDeployException;
}

