/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.diff;

import com.liferay.petra.lang.HashUtil;
import com.liferay.petra.string.StringBundler;
import java.util.ArrayList;
import java.util.List;

public class DiffResult {
    public static final String SOURCE = "SOURCE";
    public static final String TARGET = "TARGET";
    private List<String> _changedLines;
    private int _lineNumber;

    public DiffResult(int linePos, List<String> changedLines) {
        this._lineNumber = linePos + 1;
        this._changedLines = changedLines;
    }

    public DiffResult(int linePos, String changedLine) {
        this._lineNumber = linePos + 1;
        this._changedLines = new ArrayList<String>();
        this._changedLines.add(changedLine);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DiffResult)) {
            return false;
        }
        DiffResult diffResult = (DiffResult)object;
        List<String> changedLines = diffResult.getChangedLines();
        return diffResult.getLineNumber() == this._lineNumber && changedLines.equals(this._changedLines);
    }

    public List<String> getChangedLines() {
        return this._changedLines;
    }

    public int getLineNumber() {
        return this._lineNumber;
    }

    public int hashCode() {
        int hashCode = HashUtil.hash((int)0, (int)this._lineNumber);
        return HashUtil.hash((int)hashCode, this._changedLines);
    }

    public void setChangedLines(List<String> changedLines) {
        this._changedLines = changedLines;
    }

    public void setLineNumber(int lineNumber) {
        this._lineNumber = lineNumber;
    }

    public String toString() {
        StringBundler sb = new StringBundler(2 * this._changedLines.size() + 3);
        sb.append("Line: ");
        sb.append(this._lineNumber);
        sb.append("\n");
        for (String changedLine : this._changedLines) {
            sb.append(changedLine);
            sb.append("\n");
        }
        if (!this._changedLines.isEmpty()) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }
}

