/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.internal.spring.transaction;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.portal.kernel.transaction.NewTransactionLifecycleListener;
import com.liferay.portal.kernel.transaction.TransactionAttribute;
import com.liferay.portal.kernel.transaction.TransactionLifecycleListener;
import com.liferay.portal.kernel.transaction.TransactionStatus;
import java.util.ArrayDeque;
import java.util.Deque;

public class ReadOnlyTransactionThreadLocal {
    public static final TransactionLifecycleListener TRANSACTION_LIFECYCLE_LISTENER = new NewTransactionLifecycleListener(){

        @Override
        protected void doCommitted(TransactionAttribute transactionAttribute, TransactionStatus transactionStatus) {
            Deque deque = (Deque)_readOnlyTransactionThreadLocal.get();
            deque.pop();
        }

        @Override
        protected void doCreated(TransactionAttribute transactionAttribute, TransactionStatus transactionStatus) {
            Deque deque = (Deque)_readOnlyTransactionThreadLocal.get();
            deque.push(transactionAttribute.isReadOnly());
        }

        @Override
        protected void doRollbacked(TransactionAttribute transactionAttribute, TransactionStatus transactionStatus, Throwable throwable) {
            Deque deque = (Deque)_readOnlyTransactionThreadLocal.get();
            deque.pop();
        }
    };
    private static final ThreadLocal<Deque<Boolean>> _readOnlyTransactionThreadLocal = new CentralizedThreadLocal(ReadOnlyTransactionThreadLocal.class + "._readOnlyTransactionThreadLocal", ArrayDeque::new, false);

    public static boolean isReadOnly() {
        Deque<Boolean> deque = _readOnlyTransactionThreadLocal.get();
        Boolean readOnly = deque.peek();
        if (readOnly == null) {
            return false;
        }
        return readOnly;
    }
}

