/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.io.unsync;

import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;

public class UnsyncCharArrayReader
extends Reader {
    protected char[] buffer;
    protected int capacity;
    protected int index;
    protected int markIndex;

    public UnsyncCharArrayReader(char[] chars) {
        this.buffer = chars;
        this.capacity = chars.length;
        this.index = 0;
    }

    public UnsyncCharArrayReader(char[] chars, int offset, int length) {
        this.buffer = chars;
        this.index = offset;
        this.markIndex = offset;
        this.capacity = Math.min(chars.length, offset + length);
    }

    @Override
    public void close() {
        this.buffer = null;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        if (this.buffer == null) {
            throw new IOException("Stream closed");
        }
        this.markIndex = this.index;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() throws IOException {
        if (this.buffer == null) {
            throw new IOException("Stream closed");
        }
        if (this.index >= this.capacity) {
            return -1;
        }
        return this.buffer[this.index++];
    }

    @Override
    public int read(char[] chars) throws IOException {
        return this.read(chars, 0, chars.length);
    }

    @Override
    public int read(char[] chars, int offset, int length) throws IOException {
        if (this.buffer == null) {
            throw new IOException("Stream closed");
        }
        if (length <= 0) {
            return 0;
        }
        if (this.index >= this.capacity) {
            return -1;
        }
        int read = length;
        if (this.index + read > this.capacity) {
            read = this.capacity - this.index;
        }
        System.arraycopy(this.buffer, this.index, chars, offset, read);
        this.index += read;
        return read;
    }

    @Override
    public int read(CharBuffer charBuffer) throws IOException {
        if (this.buffer == null) {
            throw new IOException("Stream closed");
        }
        int length = charBuffer.remaining();
        if (length <= 0) {
            return 0;
        }
        if (this.index >= this.capacity) {
            return -1;
        }
        if (this.index + length > this.capacity) {
            length = this.capacity - this.index;
        }
        charBuffer.put(this.buffer, this.index, length);
        this.index += length;
        return length;
    }

    @Override
    public boolean ready() throws IOException {
        if (this.buffer == null) {
            throw new IOException("Stream closed");
        }
        return this.capacity > this.index;
    }

    @Override
    public void reset() throws IOException {
        if (this.buffer == null) {
            throw new IOException("Stream closed");
        }
        this.index = this.markIndex;
    }

    @Override
    public long skip(long skip) throws IOException {
        if (this.buffer == null) {
            throw new IOException("Stream closed");
        }
        if (skip < 0L) {
            return 0L;
        }
        if ((long)this.index + skip > (long)this.capacity) {
            skip = this.capacity - this.index;
        }
        this.index = (int)((long)this.index + skip);
        return skip;
    }
}

