/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.jndi;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import javax.naming.Context;
import javax.naming.NamingException;

public class JNDIUtil {
    private static final Log _log = LogFactoryUtil.getLog(JNDIUtil.class);

    public static Object lookup(Context context, String location) throws NamingException {
        return JNDIUtil._lookup(context, location);
    }

    private static Object _lookup(Context context, String location) throws NamingException {
        if (_log.isDebugEnabled()) {
            _log.debug("Lookup " + location);
        }
        Object object = null;
        try {
            object = context.lookup(location);
        }
        catch (NamingException namingException1) {
            if (location.contains("java:comp/env/")) {
                try {
                    String newLocation = StringUtil.removeSubstring(location, "java:comp/env/");
                    if (_log.isDebugEnabled()) {
                        _log.debug(namingException1.getMessage());
                        _log.debug("Attempt " + newLocation);
                    }
                    object = context.lookup(newLocation);
                }
                catch (NamingException namingException2) {
                    String newLocation = StringUtil.removeSubstring(location, "comp/env/");
                    if (_log.isDebugEnabled()) {
                        _log.debug(namingException2.getMessage());
                        _log.debug("Attempt " + newLocation);
                    }
                    object = context.lookup(newLocation);
                }
            }
            if (location.contains("java:")) {
                try {
                    String newLocation = StringUtil.removeSubstring(location, "java:");
                    if (_log.isDebugEnabled()) {
                        _log.debug(namingException1.getMessage());
                        _log.debug("Attempt " + newLocation);
                    }
                    object = context.lookup(newLocation);
                }
                catch (NamingException namingException2) {
                    String newLocation = StringUtil.replace(location, "java:", "java:comp/env/");
                    if (_log.isDebugEnabled()) {
                        _log.debug(namingException2.getMessage());
                        _log.debug("Attempt " + newLocation);
                    }
                    object = context.lookup(newLocation);
                }
            }
            if (!location.contains("java:")) {
                try {
                    String newLocation = "java:" + location;
                    if (_log.isDebugEnabled()) {
                        _log.debug(namingException1.getMessage());
                        _log.debug("Attempt " + newLocation);
                    }
                    object = context.lookup(newLocation);
                }
                catch (NamingException namingException2) {
                    String newLocation = "java:comp/env/" + location;
                    if (_log.isDebugEnabled()) {
                        _log.debug(namingException2.getMessage());
                        _log.debug("Attempt " + newLocation);
                    }
                    object = context.lookup(newLocation);
                }
            }
            throw new NamingException();
        }
        return object;
    }
}

