/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.jsonwebservice;

import com.liferay.portal.kernel.jsonwebservice.JSONWebService;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceNaming;
import com.liferay.portal.kernel.util.StringUtil;
import java.lang.reflect.Method;

public class JSONWebServiceMappingResolver {
    private final JSONWebServiceNaming _jsonWebServiceNaming;

    public JSONWebServiceMappingResolver(JSONWebServiceNaming jsonWebServiceNaming) {
        this._jsonWebServiceNaming = jsonWebServiceNaming;
    }

    public String resolveHttpMethod(Method method) {
        JSONWebService annotationJSONWebService = method.getAnnotation(JSONWebService.class);
        String httpMethod = null;
        if (annotationJSONWebService != null) {
            httpMethod = StringUtil.trim(annotationJSONWebService.method());
        }
        if (httpMethod != null && httpMethod.length() != 0) {
            return httpMethod;
        }
        return this._jsonWebServiceNaming.convertMethodToHttpMethod(method);
    }

    public String resolvePath(Class<?> clazz, Method method) {
        JSONWebService annotationJSONWebService = method.getAnnotation(JSONWebService.class);
        String path = null;
        if (annotationJSONWebService != null) {
            path = StringUtil.trim(annotationJSONWebService.value());
        }
        if (path == null || path.length() == 0) {
            path = this._jsonWebServiceNaming.convertMethodToPath(method);
        }
        if (path.startsWith("/")) {
            return path;
        }
        path = "/" + path;
        String pathFromClass = null;
        annotationJSONWebService = clazz.getAnnotation(JSONWebService.class);
        if (annotationJSONWebService != null) {
            pathFromClass = StringUtil.trim(annotationJSONWebService.value());
        }
        if (pathFromClass == null || pathFromClass.length() == 0) {
            pathFromClass = this._jsonWebServiceNaming.convertServiceClassToPath(clazz);
        }
        if (!pathFromClass.startsWith("/")) {
            pathFromClass = "/" + pathFromClass;
        }
        return pathFromClass + path;
    }
}

