/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.model.adapter;

import com.liferay.portal.kernel.model.adapter.builder.ModelAdapterBuilder;
import com.liferay.portal.kernel.model.adapter.builder.ModelAdapterBuilderLocator;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceTracker;
import java.util.ArrayList;
import java.util.List;

public class ModelAdapterUtil {
    private static final ServiceTracker<ModelAdapterBuilderLocator, ModelAdapterBuilderLocator> _modelAdapterBuilderLocatorServiceTracker;

    public static <T, V> List<V> adapt(List<T> adapteeModels, Class<T> adapteeModelClass, Class<V> adaptedModelClass) {
        ArrayList<V> adaptedModels = new ArrayList<V>();
        for (T adapteeModel : adapteeModels) {
            adaptedModels.add(ModelAdapterUtil.adapt(adapteeModel, adapteeModelClass, adaptedModelClass));
        }
        return adaptedModels;
    }

    public static <T, V> List<V> adapt(List<T> adapteeModels, Class<V> adaptedModelClass) {
        ArrayList<V> adaptedModels = new ArrayList<V>();
        for (T adapteeModel : adapteeModels) {
            adaptedModels.add(ModelAdapterUtil.adapt(adapteeModel, adaptedModelClass));
        }
        return adaptedModels;
    }

    public static <T, V> V adapt(T adapteeModel, Class<T> adapteeModelClass, Class<V> adaptedModelClass) {
        return ModelAdapterUtil.doAdapt(adapteeModel, adapteeModelClass, adaptedModelClass);
    }

    public static <T, V> V adapt(T adapteeModel, Class<V> adaptedModelClass) {
        Class<?> adapteeModelClass = adapteeModel.getClass();
        return ModelAdapterUtil.doAdapt(adapteeModel, adapteeModelClass, adaptedModelClass);
    }

    protected static <T, V> V doAdapt(T adapteeModel, Class<T> adapteeModelClass, Class<V> adaptedModelClass) {
        ModelAdapterBuilderLocator modelAdapterBuilderLocator = (ModelAdapterBuilderLocator)_modelAdapterBuilderLocatorServiceTracker.getService();
        if (modelAdapterBuilderLocator == null) {
            return null;
        }
        ModelAdapterBuilder<T, V> modelAdapterBuilder = modelAdapterBuilderLocator.locate(adapteeModelClass, adaptedModelClass);
        return modelAdapterBuilder.build(adapteeModel);
    }

    static {
        Registry registry = RegistryUtil.getRegistry();
        _modelAdapterBuilderLocatorServiceTracker = registry.trackServices(ModelAdapterBuilderLocator.class);
        _modelAdapterBuilderLocatorServiceTracker.open();
    }
}

