/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.model.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypeAccessPolicy;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.PortletModeFactory;
import com.liferay.portal.kernel.security.auth.AuthTokenUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import javax.portlet.PortletMode;
import javax.servlet.http.HttpServletRequest;

public class DefaultLayoutTypeAccessPolicyImpl
implements LayoutTypeAccessPolicy {
    private static final boolean _PORTLET_ADD_DEFAULT_RESOURCE_CHECK_ENABLED = GetterUtil.getBoolean(PropsUtil.get("portlet.add.default.resource.check.enabled"));
    private static final LayoutTypeAccessPolicy _layoutTypeAccessPolicy = new DefaultLayoutTypeAccessPolicyImpl();

    public static LayoutTypeAccessPolicy create() {
        return _layoutTypeAccessPolicy;
    }

    @Override
    public void checkAccessAllowedToPortlet(HttpServletRequest httpServletRequest, Layout layout, Portlet portlet) throws PortalException {
        String checkAccessAllowedToPortletCacheKey = StringBundler.concat((Object[])new Object[]{DefaultLayoutTypeAccessPolicyImpl.class.getName(), "#", layout.getPlid(), "#", portlet.getPortletId()});
        Boolean allowed = (Boolean)httpServletRequest.getAttribute(checkAccessAllowedToPortletCacheKey);
        if (allowed != null) {
            if (allowed.booleanValue()) {
                return;
            }
            throw new PrincipalException.MustHavePermission(PortalUtil.getUserId(httpServletRequest), StringBundler.concat((String[])new String[]{portlet.getDisplayName(), " ", portlet.getPortletId()}), 0L, "ACCESS");
        }
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String layoutFriendlyURL = layout.getFriendlyURL();
        if (layout.isSystem() && layoutFriendlyURL.equals(PropsUtil.get("control.panel.layout.friendly.url")) && PortletPermissionUtil.hasControlPanelAccessPermission(permissionChecker, themeDisplay.getScopeGroupId(), portlet)) {
            httpServletRequest.setAttribute(checkAccessAllowedToPortletCacheKey, (Object)Boolean.TRUE);
            return;
        }
        if (this.isAccessAllowedToLayoutPortlet(httpServletRequest, layout, portlet)) {
            PortalUtil.addPortletDefaultResource(httpServletRequest, portlet);
            if (this.hasAccessPermission(httpServletRequest, layout, portlet)) {
                httpServletRequest.setAttribute(checkAccessAllowedToPortletCacheKey, (Object)Boolean.TRUE);
                return;
            }
        }
        httpServletRequest.setAttribute(checkAccessAllowedToPortletCacheKey, (Object)Boolean.FALSE);
        throw new PrincipalException.MustHavePermission(PortalUtil.getUserId(httpServletRequest), StringBundler.concat((String[])new String[]{portlet.getDisplayName(), " ", portlet.getPortletId()}), 0L, "ACCESS");
    }

    @Override
    public boolean isAddLayoutAllowed(PermissionChecker permissionChecker, Layout layout) throws PortalException {
        return LayoutPermissionUtil.contains(permissionChecker, layout, "ADD_LAYOUT");
    }

    @Override
    public boolean isCustomizeLayoutAllowed(PermissionChecker permissionChecker, Layout layout) throws PortalException {
        return LayoutPermissionUtil.contains(permissionChecker, layout, "CUSTOMIZE");
    }

    @Override
    public boolean isDeleteLayoutAllowed(PermissionChecker permissionChecker, Layout layout) throws PortalException {
        return LayoutPermissionUtil.contains(permissionChecker, layout, "DELETE");
    }

    @Override
    public boolean isUpdateLayoutAllowed(PermissionChecker permissionChecker, Layout layout) throws PortalException {
        return LayoutPermissionUtil.contains(permissionChecker, layout, "UPDATE");
    }

    @Override
    public boolean isViewLayoutAllowed(PermissionChecker permissionChecker, Layout layout) throws PortalException {
        return LayoutPermissionUtil.contains(permissionChecker, layout, "VIEW");
    }

    protected boolean hasAccessPermission(HttpServletRequest httpServletRequest, Layout layout, Portlet portlet) throws PortalException {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletMode portletMode = PortletMode.VIEW;
        String portletId = portlet.getPortletId();
        String ppid = httpServletRequest.getParameter("p_p_id");
        String ppmode = httpServletRequest.getParameter("p_p_mode");
        if (portletId.equals(ppid) && ppmode != null) {
            portletMode = PortletModeFactory.getPortletMode(ppmode);
        }
        return PortletPermissionUtil.hasAccessPermission(permissionChecker, themeDisplay.getScopeGroupId(), layout, portlet, portletMode);
    }

    protected boolean isAccessAllowedToLayoutPortlet(HttpServletRequest httpServletRequest, Layout layout, Portlet portlet) {
        if (this.isAccessGrantedByRuntimePortlet(httpServletRequest)) {
            return true;
        }
        if (this.isAccessGrantedByPortletOnPage(layout, portlet)) {
            return true;
        }
        return this.isAccessGrantedByPortletAuthenticationToken(httpServletRequest, layout, portlet);
    }

    protected boolean isAccessGrantedByPortletAuthenticationToken(HttpServletRequest httpServletRequest, Layout layout, Portlet portlet) {
        if (!portlet.isAddDefaultResource()) {
            return false;
        }
        if (!_PORTLET_ADD_DEFAULT_RESOURCE_CHECK_ENABLED) {
            return true;
        }
        return AuthTokenUtil.isValidPortletInvocationToken(httpServletRequest, layout, portlet);
    }

    protected boolean isAccessGrantedByPortletOnPage(Layout layout, Portlet portlet) {
        String portletId = portlet.getPortletId();
        if (layout.isTypePanel() && this.isPanelSelectedPortlet(layout, portletId)) {
            return true;
        }
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        return layoutTypePortlet != null && layoutTypePortlet.hasPortletId(portletId);
    }

    protected boolean isAccessGrantedByRuntimePortlet(HttpServletRequest httpServletRequest) {
        Boolean renderPortletResource = (Boolean)httpServletRequest.getAttribute("RENDER_PORTLET_RESOURCE");
        if (renderPortletResource != null) {
            return renderPortletResource;
        }
        return false;
    }

    protected boolean isPanelSelectedPortlet(Layout layout, String portletId) {
        String panelSelectedPortlets = layout.getTypeSettingsProperty("panelSelectedPortlets");
        if (Validator.isNotNull(panelSelectedPortlets)) {
            Object[] panelSelectedPortletsArray = StringUtil.split(panelSelectedPortlets);
            return ArrayUtil.contains(panelSelectedPortletsArray, portletId);
        }
        return false;
    }
}

