/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.monitoring;

import com.liferay.petra.lang.HashUtil;
import com.liferay.petra.string.StringBundler;
import java.lang.reflect.Method;

public class MethodSignature {
    private final String _className;
    private final String _methodName;
    private final String[] _parameterTypeNames;

    public MethodSignature(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        this._className = clazz.getName();
        this._methodName = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        this._parameterTypeNames = new String[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            this._parameterTypeNames[i] = parameterTypes[i].getName();
        }
    }

    public MethodSignature(String className, String methodName, String[] parameterTypeNames) {
        this._className = className;
        this._methodName = methodName;
        this._parameterTypeNames = parameterTypeNames;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MethodSignature)) {
            return false;
        }
        MethodSignature methodSignature = (MethodSignature)object;
        if (this._className.equals(methodSignature._className) && this._methodName.equals(methodSignature._methodName) && this._parameterTypeNames.length == methodSignature._parameterTypeNames.length) {
            for (int i = 0; i < this._parameterTypeNames.length; ++i) {
                if (this._parameterTypeNames[i].equals(methodSignature._parameterTypeNames[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String getClassName() {
        return this._className;
    }

    public String getMethodName() {
        return this._methodName;
    }

    public String[] getParameterTypeNames() {
        return this._parameterTypeNames;
    }

    public int hashCode() {
        int hashCode = HashUtil.hash((int)0, (Object)this._className);
        hashCode = HashUtil.hash((int)hashCode, (Object)this._methodName);
        for (String parameterTypeName : this._parameterTypeNames) {
            hashCode = HashUtil.hash((int)hashCode, (Object)parameterTypeName);
        }
        return hashCode;
    }

    public String toString() {
        StringBundler sb = new StringBundler(this._parameterTypeNames.length * 2 + 5);
        sb.append("{className=");
        sb.append(this._className);
        sb.append(", methodName=");
        sb.append(this._methodName);
        sb.append(", parameterTypeNames=[");
        for (String parameterTypeName : this._parameterTypeNames) {
            sb.append(parameterTypeName);
            sb.append(", ");
        }
        sb.setIndex(sb.index() - 1);
        sb.append("]}");
        return sb.toString();
    }
}

