/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.nio.intraband;

import com.liferay.petra.executor.PortalExecutorManager;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.nio.intraband.Datagram;
import com.liferay.portal.kernel.nio.intraband.DatagramReceiveHandler;
import com.liferay.portal.kernel.nio.intraband.RegistrationReference;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import java.util.concurrent.Executor;

public abstract class BaseAsyncDatagramReceiveHandler
implements DatagramReceiveHandler {
    private static final Log _log = LogFactoryUtil.getLog(BaseAsyncDatagramReceiveHandler.class);
    private static volatile PortalExecutorManager _portalExecutorManager = ServiceProxyFactory.newServiceTrackedInstance(PortalExecutorManager.class, BaseAsyncDatagramReceiveHandler.class, "_portalExecutorManager", true);
    private final Executor _executor;

    public BaseAsyncDatagramReceiveHandler() {
        Class<?> clazz = this.getClass();
        this._executor = _portalExecutorManager.getPortalExecutor(clazz.getName());
    }

    @Override
    public void receive(RegistrationReference registrationReference, Datagram datagram) {
        this._executor.execute(new DispatchJob(registrationReference, datagram));
    }

    protected abstract void doReceive(RegistrationReference var1, Datagram var2) throws Exception;

    private class DispatchJob
    implements Runnable {
        private final Datagram _datagram;
        private final RegistrationReference _registrationReference;

        public DispatchJob(RegistrationReference registrationReference, Datagram datagram) {
            this._registrationReference = registrationReference;
            this._datagram = datagram;
        }

        @Override
        public void run() {
            try {
                BaseAsyncDatagramReceiveHandler.this.doReceive(this._registrationReference, this._datagram);
            }
            catch (Exception exception) {
                _log.error("Unable to dispatch", exception);
            }
        }
    }
}

