/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.nio.intraband.blocking;

import com.liferay.portal.kernel.nio.intraband.BaseIntraband;
import com.liferay.portal.kernel.nio.intraband.ChannelContext;
import com.liferay.portal.kernel.nio.intraband.Datagram;
import com.liferay.portal.kernel.nio.intraband.RegistrationReference;
import com.liferay.portal.kernel.nio.intraband.blocking.FutureRegistrationReference;
import com.liferay.portal.kernel.util.NamedThreadFactory;
import java.io.IOException;
import java.nio.channels.Channel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.SelectableChannel;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class ExecutorIntraband
extends BaseIntraband {
    protected static final ThreadFactory THREAD_FACTORY = new NamedThreadFactory(ExecutorIntraband.class + ".threadFactory", 5, ExecutorIntraband.class.getClassLoader());
    protected final ExecutorService executorService = Executors.newCachedThreadPool(THREAD_FACTORY);

    public ExecutorIntraband(long defaultTimeout) {
        super(defaultTimeout);
    }

    @Override
    public void close() throws InterruptedException, IOException {
        this.executorService.shutdownNow();
        this.executorService.awaitTermination(this.defaultTimeout, TimeUnit.MILLISECONDS);
        super.close();
    }

    @Override
    public RegistrationReference registerChannel(Channel channel) {
        SelectableChannel selectableChannel;
        if (channel == null) {
            throw new NullPointerException("Channel is null");
        }
        if (!(channel instanceof GatheringByteChannel)) {
            throw new IllegalArgumentException("Channel is not of type GatheringByteChannel");
        }
        if (!(channel instanceof ScatteringByteChannel)) {
            throw new IllegalArgumentException("Channel is not of type ScatteringByteChannel");
        }
        if (channel instanceof SelectableChannel && !(selectableChannel = (SelectableChannel)channel).isBlocking()) {
            throw new IllegalArgumentException("Channel is of type SelectableChannel and configured in nonblocking mode");
        }
        this.ensureOpen();
        return this.doRegisterChannel((ScatteringByteChannel)channel, (GatheringByteChannel)channel);
    }

    @Override
    public RegistrationReference registerChannel(ScatteringByteChannel scatteringByteChannel, GatheringByteChannel gatheringByteChannel) {
        SelectableChannel selectableChannel;
        if (gatheringByteChannel == null) {
            throw new NullPointerException("Gathering byte channel is null");
        }
        if (scatteringByteChannel == null) {
            throw new NullPointerException("Scattering byte channel is null");
        }
        if (scatteringByteChannel instanceof SelectableChannel && !(selectableChannel = (SelectableChannel)((Object)scatteringByteChannel)).isBlocking()) {
            throw new IllegalArgumentException("Scattering byte channel is of type SelectableChannel and configured in nonblocking mode");
        }
        if (gatheringByteChannel instanceof SelectableChannel && !(selectableChannel = (SelectableChannel)((Object)gatheringByteChannel)).isBlocking()) {
            throw new IllegalArgumentException("Gathering byte channel is of type SelectableChannel and configured in nonblocking mode");
        }
        this.ensureOpen();
        return this.doRegisterChannel(scatteringByteChannel, gatheringByteChannel);
    }

    protected RegistrationReference doRegisterChannel(ScatteringByteChannel scatteringByteChannel, GatheringByteChannel gatheringByteChannel) {
        LinkedBlockingQueue<Datagram> sendingQueue = new LinkedBlockingQueue<Datagram>();
        ChannelContext channelContext = new ChannelContext(sendingQueue);
        ReadingCallable readingCallable = new ReadingCallable(scatteringByteChannel, channelContext);
        WritingCallable writingCallable = new WritingCallable(gatheringByteChannel, channelContext);
        Future<Void> readFuture = this.executorService.submit(readingCallable);
        Future<Void> writeFuture = this.executorService.submit(writingCallable);
        FutureRegistrationReference futureRegistrationReference = new FutureRegistrationReference(this, channelContext, readFuture, writeFuture);
        channelContext.setRegistrationReference(futureRegistrationReference);
        readingCallable.openLatch();
        writingCallable.openLatch();
        return futureRegistrationReference;
    }

    @Override
    protected void doSendDatagram(RegistrationReference registrationReference, Datagram datagram) {
        FutureRegistrationReference futureRegistrationReference = (FutureRegistrationReference)registrationReference;
        ChannelContext channelContext = futureRegistrationReference.channelContext;
        Queue<Datagram> sendingQueue = channelContext.getSendingQueue();
        sendingQueue.offer(datagram);
    }

    protected class WritingCallable
    implements Callable<Void> {
        private final ChannelContext _channelContext;
        private final CountDownLatch _countDownLatch;
        private final GatheringByteChannel _gatheringByteChannel;

        public WritingCallable(GatheringByteChannel gatheringByteChannel, ChannelContext channelContext) {
            this._gatheringByteChannel = gatheringByteChannel;
            this._channelContext = channelContext;
            this._countDownLatch = new CountDownLatch(1);
        }

        @Override
        public Void call() throws Exception {
            this._countDownLatch.await();
            try {
                BlockingQueue sendingQueue = (BlockingQueue)this._channelContext.getSendingQueue();
                while (true) {
                    Datagram datagram = (Datagram)sendingQueue.take();
                    this._channelContext.setWritingDatagram(datagram);
                    if (!ExecutorIntraband.this.handleWriting(this._gatheringByteChannel, this._channelContext)) {
                        if (this._gatheringByteChannel.isOpen()) {
                            throw new IllegalStateException(this._gatheringByteChannel + " behaved in nonblocking way.");
                        }
                        break;
                    }
                    ExecutorIntraband.this.cleanUpTimeoutResponseWaitingDatagrams();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return null;
        }

        public void openLatch() {
            this._countDownLatch.countDown();
        }
    }

    protected class ReadingCallable
    implements Callable<Void> {
        private final ChannelContext _channelContext;
        private final CountDownLatch _countDownLatch;
        private final ScatteringByteChannel _scatteringByteChannel;

        public ReadingCallable(ScatteringByteChannel scatteringByteChannel, ChannelContext channelContext) {
            this._scatteringByteChannel = scatteringByteChannel;
            this._channelContext = channelContext;
            this._countDownLatch = new CountDownLatch(1);
        }

        @Override
        public Void call() throws Exception {
            this._countDownLatch.await();
            while (this._scatteringByteChannel.isOpen()) {
                ExecutorIntraband.this.handleReading(this._scatteringByteChannel, this._channelContext);
            }
            return null;
        }

        public void openLatch() {
            this._countDownLatch.countDown();
        }
    }
}

