/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.nio.intraband.messaging;

import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.nio.intraband.messaging.IntrabandBridgeDestination;
import com.liferay.portal.kernel.process.ProcessCallable;
import com.liferay.portal.kernel.process.ProcessException;

public class DestinationConfigurationProcessCallable
implements ProcessCallable<Boolean> {
    private static final long serialVersionUID = 1L;
    private final String _destinationName;

    public DestinationConfigurationProcessCallable(String destinationName) {
        this._destinationName = destinationName;
    }

    @Override
    public Boolean call() throws ProcessException {
        MessageBus messageBus = MessageBusUtil.getMessageBus();
        Destination destination = messageBus.getDestination(this._destinationName);
        if (destination == null) {
            throw new ProcessException("No such destination " + destination);
        }
        if (destination instanceof IntrabandBridgeDestination) {
            return Boolean.FALSE;
        }
        IntrabandBridgeDestination intrabandBridgeDestination = new IntrabandBridgeDestination(destination);
        messageBus.addDestination(intrabandBridgeDestination);
        return Boolean.TRUE;
    }
}

