/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.poller;

import com.liferay.portal.kernel.poller.PollerException;
import com.liferay.portal.kernel.poller.PollerProcessor;
import com.liferay.portal.kernel.poller.PollerRequest;
import com.liferay.portal.kernel.poller.PollerResponse;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.Map;

public abstract class BasePollerProcessor
implements PollerProcessor {
    @Override
    public PollerResponse receive(PollerRequest pollerRequest) throws PollerException {
        try {
            return this.doReceive(pollerRequest);
        }
        catch (Exception exception) {
            throw new PollerException(exception);
        }
    }

    @Override
    public void send(PollerRequest pollerRequest) throws PollerException {
        try {
            this.doSend(pollerRequest);
        }
        catch (Exception exception) {
            throw new PollerException(exception);
        }
    }

    protected abstract PollerResponse doReceive(PollerRequest var1) throws Exception;

    protected abstract void doSend(PollerRequest var1) throws Exception;

    protected boolean getBoolean(PollerRequest pollerRequest, String name) {
        return this.getBoolean(pollerRequest, name, false);
    }

    protected boolean getBoolean(PollerRequest pollerRequest, String name, boolean defaultValue) {
        Map<String, String> parameterMap = pollerRequest.getParameterMap();
        return GetterUtil.getBoolean(parameterMap.get(name), defaultValue);
    }

    protected double getDouble(PollerRequest pollerRequest, String name) {
        return this.getDouble(pollerRequest, name, -1.0);
    }

    protected double getDouble(PollerRequest pollerRequest, String name, double defaultValue) {
        Map<String, String> parameterMap = pollerRequest.getParameterMap();
        return GetterUtil.getDouble(parameterMap.get(name), defaultValue);
    }

    protected int getInteger(PollerRequest pollerRequest, String name) {
        return this.getInteger(pollerRequest, name, -1);
    }

    protected int getInteger(PollerRequest pollerRequest, String name, int defaultValue) {
        Map<String, String> parameterMap = pollerRequest.getParameterMap();
        return GetterUtil.getInteger(parameterMap.get(name), defaultValue);
    }

    protected long getLong(PollerRequest pollerRequest, String name) {
        return this.getLong(pollerRequest, name, -1L);
    }

    protected long getLong(PollerRequest pollerRequest, String name, long defaultValue) {
        Map<String, String> parameterMap = pollerRequest.getParameterMap();
        return GetterUtil.getLong(parameterMap.get(name), defaultValue);
    }

    protected String getString(PollerRequest pollerRequest, String name) {
        return this.getString(pollerRequest, name, null);
    }

    protected String getString(PollerRequest pollerRequest, String name, String defaultValue) {
        Map<String, String> parameterMap = pollerRequest.getParameterMap();
        return GetterUtil.getString(parameterMap.get(name), defaultValue);
    }
}

