/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet;

import com.liferay.portal.kernel.portlet.LiferayPortletMode;
import com.liferay.portal.kernel.util.Validator;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletMode;

public class PortletModeFactory {
    private static final Map<String, PortletMode> _portletModes = new HashMap<String, PortletMode>(){
        {
            try {
                for (Field field : LiferayPortletMode.class.getFields()) {
                    if (!Modifier.isStatic(field.getModifiers()) || field.getType() != PortletMode.class) continue;
                    PortletMode portletMode = (PortletMode)field.get(null);
                    this.put(portletMode.toString(), portletMode);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ExceptionInInitializerError(illegalAccessException);
            }
        }
    };

    public static PortletMode getPortletMode(String name) {
        return PortletModeFactory.getPortletMode(name, 2);
    }

    public static PortletMode getPortletMode(String name, int portletMajorVersion) {
        if (Validator.isNull(name)) {
            if (portletMajorVersion < 3) {
                return PortletMode.VIEW;
            }
            return PortletMode.UNDEFINED;
        }
        PortletMode portletMode = _portletModes.get(name);
        if (portletMode == null) {
            portletMode = new PortletMode(name);
        }
        return portletMode;
    }
}

