/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.BrowserSnifferUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceResponse;

public class PortletResponseUtil {
    private static final Log _log = LogFactoryUtil.getLog(PortletResponseUtil.class);

    public static void sendFile(PortletRequest portletRequest, MimeResponse mimeResponse, String fileName, byte[] bytes) throws IOException {
        PortletResponseUtil.sendFile(portletRequest, mimeResponse, fileName, bytes, null);
    }

    public static void sendFile(PortletRequest portletRequest, MimeResponse mimeResponse, String fileName, byte[] bytes, String contentType) throws IOException {
        PortletResponseUtil.sendFile(portletRequest, mimeResponse, fileName, bytes, contentType, null);
    }

    public static void sendFile(PortletRequest portletRequest, MimeResponse mimeResponse, String fileName, byte[] bytes, String contentType, String contentDispositionType) throws IOException {
        PortletResponseUtil.setHeaders(portletRequest, mimeResponse, fileName, contentType, contentDispositionType);
        PortletResponseUtil.write(mimeResponse, bytes);
    }

    public static void sendFile(PortletRequest portletRequest, MimeResponse mimeResponse, String fileName, InputStream inputStream) throws IOException {
        PortletResponseUtil.sendFile(portletRequest, mimeResponse, fileName, inputStream, null);
    }

    public static void sendFile(PortletRequest portletRequest, MimeResponse mimeResponse, String fileName, InputStream inputStream, int contentLength, String contentType) throws IOException {
        PortletResponseUtil.sendFile(portletRequest, mimeResponse, fileName, inputStream, contentLength, contentType, null);
    }

    public static void sendFile(PortletRequest portletRequest, MimeResponse mimeResponse, String fileName, InputStream inputStream, int contentLength, String contentType, String contentDispositionType) throws IOException {
        PortletResponseUtil.setHeaders(portletRequest, mimeResponse, fileName, contentType, contentDispositionType);
        PortletResponseUtil.write(mimeResponse, inputStream, contentLength);
    }

    public static void sendFile(PortletRequest portletRequest, MimeResponse mimeResponse, String fileName, InputStream inputStream, String contentType) throws IOException {
        PortletResponseUtil.sendFile(portletRequest, mimeResponse, fileName, inputStream, 0, contentType);
    }

    public static void write(MimeResponse mimeResponse, byte[] bytes) throws IOException {
        PortletResponseUtil.write(mimeResponse, bytes, 0, 0);
    }

    public static void write(MimeResponse mimeResponse, byte[] bytes, int offset, int contentLength) throws IOException {
        if (!mimeResponse.isCommitted()) {
            if (contentLength == 0) {
                contentLength = bytes.length;
            }
            if (mimeResponse instanceof ResourceResponse) {
                ResourceResponse resourceResponse = (ResourceResponse)mimeResponse;
                resourceResponse.setContentLength(contentLength);
            }
            OutputStream outputStream = mimeResponse.getPortletOutputStream();
            outputStream.write(bytes, offset, contentLength);
        }
    }

    public static void write(MimeResponse mimeResponse, byte[][] bytesArray) throws IOException {
        if (mimeResponse.isCommitted()) {
            return;
        }
        long contentLength = 0L;
        for (byte[] bytes : bytesArray) {
            contentLength += (long)bytes.length;
        }
        if (mimeResponse instanceof ResourceResponse) {
            ResourceResponse resourceResponse = (ResourceResponse)mimeResponse;
            PortletResponseUtil.setContentLength(resourceResponse, contentLength);
        }
        OutputStream outputStream = mimeResponse.getPortletOutputStream();
        for (byte[] bytes : bytesArray) {
            outputStream.write(bytes);
        }
    }

    public static void write(MimeResponse mimeResponse, File file) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            FileChannel fileChannel = fileInputStream.getChannel();
            long contentLength = fileChannel.size();
            if (mimeResponse instanceof ResourceResponse) {
                ResourceResponse resourceResponse = (ResourceResponse)mimeResponse;
                PortletResponseUtil.setContentLength(resourceResponse, contentLength);
            }
            fileChannel.transferTo(0L, contentLength, Channels.newChannel(mimeResponse.getPortletOutputStream()));
        }
    }

    public static void write(MimeResponse mimeResponse, InputStream inputStream) throws IOException {
        PortletResponseUtil.write(mimeResponse, inputStream, 0);
    }

    public static void write(MimeResponse mimeResponse, InputStream inputStream, int contentLength) throws IOException {
        if (mimeResponse.isCommitted()) {
            block5: {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException ioException) {
                        if (!_log.isWarnEnabled()) break block5;
                        _log.warn(ioException, ioException);
                    }
                }
            }
            return;
        }
        if (contentLength > 0 && mimeResponse instanceof ResourceResponse) {
            ResourceResponse resourceResponse = (ResourceResponse)mimeResponse;
            resourceResponse.setContentLength(contentLength);
        }
        StreamUtil.transfer(inputStream, mimeResponse.getPortletOutputStream());
    }

    public static void write(MimeResponse mimeResponse, String s) throws IOException {
        PortletResponseUtil.write(mimeResponse, s.getBytes("UTF-8"));
    }

    protected static void setContentLength(ResourceResponse response, long contentLength) {
        response.setProperty("Content-Length", String.valueOf(contentLength));
    }

    protected static void setHeaders(PortletRequest portletRequest, MimeResponse mimeResponse, String fileName, String contentType, String contentDispositionType) {
        String contentDispositionFileName;
        block10: {
            if (_log.isDebugEnabled()) {
                _log.debug("Sending file of type " + contentType);
            }
            if (Validator.isNotNull(contentType)) {
                mimeResponse.setContentType(contentType);
            }
            mimeResponse.setProperty("Cache-Control", "private");
            if (Validator.isNull(fileName)) {
                return;
            }
            contentDispositionFileName = "filename=\"" + fileName + "\"";
            boolean ascii = true;
            for (int i = 0; i < fileName.length(); ++i) {
                if (Validator.isAscii(fileName.charAt(i))) continue;
                ascii = false;
                break;
            }
            try {
                if (!ascii) {
                    String encodedFileName = URLCodec.encodeURL(fileName, true);
                    contentDispositionFileName = BrowserSnifferUtil.isIe(PortalUtil.getHttpServletRequest(portletRequest)) ? "filename=\"" + encodedFileName + "\"" : "filename*=UTF-8''" + encodedFileName;
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block10;
                _log.warn(exception, exception);
            }
        }
        if (Validator.isNull(contentDispositionType)) {
            String extension = GetterUtil.getString(FileUtil.getExtension(fileName));
            extension = StringUtil.toLowerCase(extension);
            Object[] mimeTypesContentDispositionInline = null;
            try {
                mimeTypesContentDispositionInline = PropsUtil.getArray("mime.types.content.disposition.inline");
            }
            catch (Exception exception) {
                mimeTypesContentDispositionInline = new String[]{};
            }
            contentDispositionType = ArrayUtil.contains(mimeTypesContentDispositionInline, extension) ? "inline" : "attachment";
        }
        StringBundler sb = new StringBundler(4);
        sb.append(contentDispositionType);
        sb.append(";");
        sb.append(" ");
        sb.append(contentDispositionFileName);
        mimeResponse.setProperty("Content-Disposition", sb.toString());
    }
}

