/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet.configuration.icon;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.configuration.icon.BasePortletConfigurationIcon;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BaseJSPPortletConfigurationIcon
extends BasePortletConfigurationIcon {
    private static final Log _log = LogFactoryUtil.getLog(BaseJSPPortletConfigurationIcon.class);
    private ServletContext _servletContext;

    public abstract String getJspPath();

    public ServletContext getServletContext() {
        return this._servletContext;
    }

    @Override
    public boolean include(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String jspPath = this.getJspPath();
        if (Validator.isNull(jspPath)) {
            return false;
        }
        RequestDispatcher requestDispatcher = this._servletContext.getRequestDispatcher(jspPath);
        try {
            requestDispatcher.include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        catch (ServletException servletException) {
            _log.error("Unable to include JSP " + jspPath, servletException);
            return false;
        }
        return true;
    }

    public void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
    }
}

