/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Namespace;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import java.text.Format;
import java.util.Date;

public class OpenSearchUtil {
    public static final int DEFAULT_NAMESPACE = 0;
    public static final int LIFERAY_NAMESPACE = 4;
    public static final int NO_NAMESPACE = 3;
    public static final int OS_NAMESPACE = 1;
    public static final int RELEVANCE_NAMESPACE = 2;
    private static final Format _dateFormat = FastDateFormatFactoryUtil.getSimpleDateFormat("yyyy-MM-dd'T'HH:mm:sszzz");

    public static Element addElement(Element el, String name, int namespaceType) {
        return el.addElement(OpenSearchUtil.getQName(name, namespaceType));
    }

    public static Element addElement(Element el, String name, int namespaceType, Date value) {
        return OpenSearchUtil.addElement(el, name, namespaceType, _dateFormat.format(value));
    }

    public static Element addElement(Element el, String name, int namespaceType, double value) {
        return OpenSearchUtil.addElement(el, name, namespaceType, String.valueOf(value));
    }

    public static Element addElement(Element el, String name, int namespaceType, int value) {
        return OpenSearchUtil.addElement(el, name, namespaceType, String.valueOf(value));
    }

    public static Element addElement(Element el, String name, int namespaceType, long value) {
        return OpenSearchUtil.addElement(el, name, namespaceType, String.valueOf(value));
    }

    public static Element addElement(Element el, String name, int namespaceType, String value) {
        Element returnElement = el.addElement(OpenSearchUtil.getQName(name, namespaceType));
        returnElement.addCDATA(value);
        return returnElement;
    }

    public static void addLink(Element root, String searchURL, String rel, String keywords, int page, int itemsPerPage) {
        Element link = OpenSearchUtil.addElement(root, "link", 0);
        link.addAttribute("rel", rel);
        searchURL = HttpUtil.addParameter(searchURL, "keywords", URLCodec.encodeURL(keywords));
        searchURL = HttpUtil.addParameter(searchURL, "p", page);
        searchURL = HttpUtil.addParameter(searchURL, "c", itemsPerPage);
        searchURL = HttpUtil.addParameter(searchURL, "format", "atom");
        link.addAttribute("href", searchURL);
        link.addAttribute("type", "application/atom+xml");
    }

    public static Namespace getNamespace(int namespaceType) {
        Namespace namespace = null;
        if (namespaceType == 0) {
            namespace = SAXReaderUtil.createNamespace("", "http://www.w3.org/2005/Atom");
        } else if (namespaceType == 4) {
            namespace = SAXReaderUtil.createNamespace("liferay", "http://liferay.com/spec/liferay-search/1.0/");
        } else if (namespaceType == 1) {
            namespace = SAXReaderUtil.createNamespace("opensearch", "http://a9.com/-/spec/opensearch/1.1/");
        } else if (namespaceType == 2) {
            namespace = SAXReaderUtil.createNamespace("relevance", "http://a9.com/-/opensearch/extensions/relevance/1.0/");
        }
        return namespace;
    }

    public static QName getQName(String name, int namespaceType) {
        if (3 == namespaceType) {
            return SAXReaderUtil.createQName(name);
        }
        return SAXReaderUtil.createQName(name, OpenSearchUtil.getNamespace(namespaceType));
    }
}

